/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;

public class AdvancedSkinTypes {
    private static final ArrayList<Entry> ALL_TYPES = new ArrayList();
    public static final Entry GENERAL_ARMOR_HEAD = AdvancedSkinTypes.register("general", SkinTypes.ARMOR_HEAD);
    public static final Entry GENERAL_ARMOR_CHEST = AdvancedSkinTypes.register("general", SkinTypes.ARMOR_CHEST);
    public static final Entry GENERAL_ARMOR_FEET = AdvancedSkinTypes.register("general", SkinTypes.ARMOR_FEET);
    public static final Entry GENERAL_ARMOR_LEGS = AdvancedSkinTypes.register("general", SkinTypes.ARMOR_LEGS);
    public static final Entry GENERAL_ARMOR_WINGS = AdvancedSkinTypes.register("general", SkinTypes.ARMOR_WINGS);
    public static final Entry GENERAL_ARMOR_OUTFIT = AdvancedSkinTypes.register("general", SkinTypes.OUTFIT);
    public static final Entry GENERAL_ITEM_SWORD = AdvancedSkinTypes.register("general", SkinTypes.ITEM_SWORD);
    public static final Entry GENERAL_ITEM_SHIELD = AdvancedSkinTypes.register("general", SkinTypes.ITEM_SHIELD);
    public static final Entry GENERAL_ITEM_BOW = AdvancedSkinTypes.register("general", SkinTypes.ITEM_BOW);
    public static final Entry GENERAL_ITEM_TRIDENT = AdvancedSkinTypes.register("general", SkinTypes.ITEM_TRIDENT);
    public static final Entry GENERAL_TOOL_PICKAXE = AdvancedSkinTypes.register("general", SkinTypes.TOOL_PICKAXE);
    public static final Entry GENERAL_TOOL_AXE = AdvancedSkinTypes.register("general", SkinTypes.TOOL_AXE);
    public static final Entry GENERAL_TOOL_SHOVEL = AdvancedSkinTypes.register("general", SkinTypes.TOOL_SHOVEL);
    public static final Entry GENERAL_TOOL_HOE = AdvancedSkinTypes.register("general", SkinTypes.TOOL_HOE);
    public static final Entry OTHER_ITEM = AdvancedSkinTypes.register("other", SkinTypes.ITEM);
    public static final Entry OTHER_BLOCK = AdvancedSkinTypes.register("other", SkinTypes.BLOCK);

    public static void forEach(BiConsumer<String, List<Entry>> consumer) {
        ArrayList names = new ArrayList();
        HashMap sections = new HashMap();
        Function<String, List> builder = name -> {
            names.add(name);
            return new ArrayList();
        };
        ALL_TYPES.forEach(it -> ((List)sections.computeIfAbsent(it.category, builder)).add(it));
        for (String name2 : names) {
            consumer.accept(name2, (List)sections.get(name2));
        }
    }

    public static ArrayList<Entry> values() {
        return ALL_TYPES;
    }

    private static Entry register(String category, ISkinType skinType) {
        Entry advancedSkinType = new Entry(category, skinType);
        ALL_TYPES.add(advancedSkinType);
        return advancedSkinType;
    }

    public static class Entry {
        private final String category;
        private final ISkinType skinType;

        public Entry(String category, ISkinType skinType) {
            this.category = category;
            this.skinType = skinType;
        }

        public String getCategory() {
            return this.category;
        }

        public ISkinType getType() {
            return this.skinType;
        }
    }
}

