/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.panel;

import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UISliderBox;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerBaseSkinPanel;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerAdvancedSkinPanel
extends ArmourerBaseSkinPanel {
    public ArmourerAdvancedSkinPanel(SkinProperties skinProperties) {
        super(skinProperties);
    }

    @Override
    public void init() {
        super.init();
        this.addLabel(0, 0, new NSString("Translate"));
        this.addSliderBox(0, 0, 154, 10, -128.0, 128.0, "", SkinProperty.TRANSFORM_TRANSLATE_X);
        this.addSliderBox(0, 0, 154, 10, -128.0, 128.0, "", SkinProperty.TRANSFORM_TRANSLATE_Y);
        this.addSliderBox(0, 0, 154, 10, -128.0, 128.0, "", SkinProperty.TRANSFORM_TRANSLATE_Z);
        this.addLabel(0, 0, new NSString("Rotation"));
        this.addSliderBox(0, 0, 154, 10, -180.0, 180.0, "\u00b0", SkinProperty.TRANSFORM_ROTATION_X);
        this.addSliderBox(0, 0, 154, 10, -180.0, 180.0, "\u00b0", SkinProperty.TRANSFORM_ROTATION_Y);
        this.addSliderBox(0, 0, 154, 10, -180.0, 180.0, "\u00b0", SkinProperty.TRANSFORM_ROTATION_Z);
        this.addLabel(0, 0, new NSString("Scale"));
        this.addSliderBox(0, 0, 154, 10, Lists.newArrayList((Object[])new Double[]{0.25, 0.5, 1.0, 2.0, 4.0}), "", SkinProperty.TRANSFORM_SCALE);
    }

    protected UISliderBox addSliderBox(int x, int y, int width, int height, List<Double> values, String suffix, SkinProperty<Double> property) {
        Function<Double, Integer> transform = Double::intValue;
        UISliderBox slider = this.addSliderBox(x, y, width, height, 0.0, values.size(), suffix, property);
        slider.setFormatter(value -> new NSString(String.format("%.2f%s", values.get((Integer)transform.apply((Double)value)), suffix)));
        slider.setMaxValue(values.size() - 1);
        slider.setMinValue(0.0);
        slider.setValue(values.indexOf(this.skinProperties.get(property)));
        slider.removeTarget(this, UIControl.Event.EDITING_DID_END);
        slider.addTarget(this, UIControl.Event.EDITING_DID_END, (self, box) -> {
            double value = ((UISliderBox)box).value();
            this.skinProperties.put(property, (Double)values.get((Integer)transform.apply(value)));
            this.apply();
        });
        return slider;
    }
}

