/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIBarItem;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIScrollView;
import com.apple.library.uikit.UIScrollViewDelegate;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.init.ModTextures;

public class DrawerToolbar
extends UIView
implements UIScrollViewDelegate {
    protected final UIScrollView sidebarView = new UIScrollView(CGRect.ZERO);
    protected final UIScrollView containerView = new UIScrollView(CGRect.ZERO);
    protected final UIImage badgeBackgroundImage;
    private UIView displayView;
    private final ArrayList<UIButton> entities = new ArrayList();

    public DrawerToolbar(CGRect frame) {
        super(frame);
        this.badgeBackgroundImage = ModTextures.buttonImage(ModTextures.ADVANCED_SKIN_BUILDER, 0.0f, 48.0f, 24.0f, 24.0f);
        this.sidebarView.setFrame(new CGRect(0.0f, 0.0f, this.getBarSize(), frame.height));
        this.sidebarView.setAutoresizingMask(20);
        this.sidebarView.setShowsVerticalScrollIndicator(false);
        this.sidebarView.setDelegate(this);
        this.addSubview(this.sidebarView);
        this.containerView.setFrame(new CGRect(this.getBarSize(), 0.0f, frame.width - this.getBarSize(), frame.height));
        this.containerView.setAutoresizingMask(18);
        this.containerView.setContents(UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(52.0f, 24.0f).fixed(20.0f, 24.0f).clip(4.0f, 0.0f, 4.0f, 4.0f).build());
        this.containerView.setShowsVerticalScrollIndicator(false);
        this.containerView.setDelegate(this);
        this.addSubview(this.containerView);
    }

    public void addPage(UIView contentView, UIBarItem barItem) {
        UIEdgeInsets edg = barItem.imageInsets();
        UIButton badgeView = new UIButton(new CGRect(0.0f, 0.0f, this.getBarSize(), this.getBarSize()));
        badgeView.setImage(barItem.getImage(), 0);
        badgeView.setImageEdgeInsets(new UIEdgeInsets(edg.top + 2.0f, edg.left + 2.0f, edg.bottom + 2.0f, edg.right + 0.0f));
        badgeView.setBackgroundImage(this.badgeBackgroundImage, 7);
        badgeView.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, (self, sender) -> self.switchToPage((UIControl)sender, contentView));
        this.entities.add(badgeView);
        this.sidebarView.addSubview(badgeView);
        if (this.entities.size() == 1) {
            this.switchToPage(this.entities.get(0), contentView);
        }
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        float y = 0.0f;
        for (UIButton entity : this.entities) {
            if (y != 0.0f) {
                y += 5.0f;
            }
            CGRect rect = entity.frame().copy();
            rect.y = y;
            entity.setFrame(rect);
            y += rect.height;
        }
        this.sidebarView.setContentSize(new CGSize(0.0f, y));
    }

    protected float getBarSize() {
        return 24.0f;
    }

    protected void switchToPage(UIControl sender, UIView contentView) {
        for (UIButton entity : this.entities) {
            entity.setSelected(false);
        }
        sender.setSelected(true);
        if (this.displayView != null) {
            this.displayView.removeFromSuperview();
        }
        this.displayView = contentView;
        if (this.displayView != null) {
            this.containerView.addSubview(this.displayView);
            CGRect bounds = this.containerView.bounds();
            CGSize size = this.displayView.sizeThatFits(bounds.size());
            this.displayView.setFrame(new CGRect(0.0f, 0.0f, bounds.width, Math.max(bounds.height, size.height)));
            this.containerView.setContentSize(new CGSize(0.0f, size.height));
        }
    }
}

