/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.impl.KeyboardManagerImpl;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;

public class Shortcut {
    private static final ImmutableMap<String, Condition> TESTER = ImmutableMap.builder().put((Object)"key.keyboard.control", (k1, k2) -> KeyboardManagerImpl.hasControlDown()).put((Object)"key.keyboard.shift", (k1, k2) -> KeyboardManagerImpl.hasShiftDown()).put((Object)"key.keyboard.alt", (k1, k2) -> KeyboardManagerImpl.hasAltDown()).build();
    private final ArrayList<Condition> conditions;

    private Shortcut(ArrayList<Condition> conditions) {
        this.conditions = conditions;
    }

    public static Shortcut of(String ... keyNames) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (String keyName : keyNames) {
            Condition condition = (Condition)TESTER.get((Object)keyName);
            if (condition != null) {
                conditions.add(condition);
                continue;
            }
            InputConstants.Key key = InputConstants.m_84851_((String)keyName);
            conditions.add((i, j) -> {
                if (i == InputConstants.f_84822_.m_84873_()) {
                    return key.m_84868_() == InputConstants.Type.SCANCODE && key.m_84873_() == j;
                }
                return key.m_84868_() == InputConstants.Type.KEYSYM && key.m_84873_() == i;
            });
        }
        return new Shortcut(conditions);
    }

    public boolean matches(int key1, int key2) {
        for (Condition condition : this.conditions) {
            if (condition.test(key1, key2)) continue;
            return false;
        }
        return true;
    }

    public static interface Condition {
        public boolean test(int var1, int var2);
    }
}

