/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.guide.IGuideDataProvider;
import moe.plushie.armourers_workshop.api.client.guide.IGuideRenderer;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideRendererManager;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.client.other.SkinDynamicTexture;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.TextureUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerBlockEntityRenderer<T extends ArmourerBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private final PlayerTextureOverride override = new PlayerTextureOverride();
    private final Rectangle3f originBox = new Rectangle3f(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f);
    private final GuideRendererManager rendererManager = new GuideRendererManager();

    public ArmourerBlockEntityRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public void render(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        ISkinType skinType = ((ArmourerBlockEntity)entity).getSkinType();
        SkinProperties skinProperties = ((ArmourerBlockEntity)entity).getSkinProperties();
        RenderData renderData = RenderData.of(entity);
        renderData.tick();
        ResourceLocation playerTexture = renderData.displayTextureLocation;
        if (playerTexture != null) {
            this.override.setTexture(playerTexture);
            this.override.setBuffers(buffers);
            buffers = this.override;
        }
        boolean isMultiBlocks = skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK);
        boolean isShowGuides = ((ArmourerBlockEntity)entity).isShowGuides();
        boolean isShowModelGuides = ((ArmourerBlockEntity)entity).isShowModelGuides();
        boolean isShowHelper = ((ArmourerBlockEntity)entity).isShowHelper();
        boolean isUseHelper = ((ArmourerBlockEntity)entity).isUseHelper();
        renderData.shouldRenderOverlay = !isUseHelper;
        renderData.skinProperties = skinProperties;
        poseStack.m_85836_();
        this.transform(poseStack, entity);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        float polygonOffset = 0.0f;
        for (ISkinPartType iSkinPartType : skinType.getParts()) {
            IGuideRenderer guideRenderer;
            IVector3i origin = iSkinPartType.getOffset();
            IRectangle3i rect = iSkinPartType.getBuildingSpace();
            IRectangle3i rect2 = iSkinPartType.getGuideSpace();
            float r = 0.5f;
            float g = 0.5f;
            float b = 0.5f;
            float a = 0.25f;
            if (iSkinPartType == SkinPartTypes.BLOCK_MULTI && !isMultiBlocks) continue;
            if (iSkinPartType == SkinPartTypes.BLOCK && isMultiBlocks) {
                r = 1.0f;
                g = 1.0f;
                b = 0.0f;
                a = 0.2f;
            }
            boolean isModelOverridden = ((ArmourerBlockEntity)entity).isModelOverridden(iSkinPartType);
            if (isUseHelper) {
                isModelOverridden = !isShowHelper;
            }
            poseStack.m_85836_();
            poseStack.m_252880_((float)origin.getX(), (float)(origin.getY() + rect.getMinY()), (float)origin.getZ());
            poseStack.m_252880_(polygonOffset, polygonOffset, polygonOffset);
            if (!isModelOverridden && (guideRenderer = this.rendererManager.getRenderer(iSkinPartType)) != null) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, (float)(-rect2.getMinY()), 0.0f);
                poseStack.m_85841_(16.0f, 16.0f, 16.0f);
                guideRenderer.render(poseStack, renderData, 0xF000F0, OverlayTexture.f_118083_, buffers);
                poseStack.m_85849_();
            }
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            if (isShowGuides) {
                RenderSystem.drawCube(poseStack, rect, r, g, b, a, buffers);
                RenderSystem.drawCube(poseStack, this.originBox, 0.0f, 1.0f, 0.0f, 0.5f, buffers);
            }
            if (isShowModelGuides && isModelOverridden) {
                RenderSystem.drawCube(poseStack, rect2, 0.0f, 0.0f, 1.0f, 0.25f, buffers);
            }
            poseStack.m_85849_();
            polygonOffset += 0.001f;
        }
        poseStack.m_85849_();
        this.override.setBuffers(null);
    }

    public void transform(PoseStack poseStack, T entity) {
        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        ABI.mulPose(poseStack, CubeTransform.getRotationDegrees(((ArmourerBlockEntity)entity).getFacing()));
    }

    public int m_142163_() {
        return 272;
    }

    public boolean shouldRenderOffScreen(T entity) {
        return true;
    }

    public static class PlayerTextureOverride
    implements MultiBufferSource {
        protected final HashMap<RenderType, Supplier<RenderType>> overrides = new HashMap();
        protected ResourceLocation texture;
        protected MultiBufferSource buffers;

        public void setBuffers(MultiBufferSource buffers) {
            this.buffers = buffers;
        }

        public void setTexture(ResourceLocation texture) {
            if (Objects.equals(this.texture, texture)) {
                return;
            }
            this.overrides.clear();
            this.overrides.put(SkinRenderType.PLAYER_CUTOUT_NO_CULL, () -> SkinRenderType.entityCutoutNoCull(texture));
            this.overrides.put(SkinRenderType.PLAYER_CUTOUT, () -> SkinRenderType.entityCutoutNoCull(texture));
            this.overrides.put(SkinRenderType.PLAYER_TRANSLUCENT, () -> SkinRenderType.entityTranslucentCull(texture));
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            Supplier<RenderType> overrideRenderType = this.overrides.get(renderType);
            if (overrideRenderType != null) {
                renderType = overrideRenderType.get();
            }
            return this.buffers.m_6299_(renderType);
        }
    }

    public static class RenderData
    implements IGuideDataProvider {
        protected final ArmourerBlockEntity blockEntity;
        protected final SkinDynamicTexture displayTexture;
        protected final ResourceLocation displayTextureLocation;
        protected int lastVersion;
        protected boolean shouldRenderOverlay = false;
        protected ISkinProperties skinProperties;

        public RenderData(ArmourerBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
            this.displayTexture = new SkinDynamicTexture();
            this.displayTextureLocation = Minecraft.m_91087_().m_91097_().m_118490_(RenderData.identifier(blockEntity), (DynamicTexture)this.displayTexture);
        }

        public static RenderData of(ArmourerBlockEntity blockEntity) {
            Object renderData = blockEntity.getRenderData();
            if (renderData instanceof RenderData) {
                return (RenderData)renderData;
            }
            RenderData renderData1 = new RenderData(blockEntity);
            blockEntity.setRenderData(renderData1);
            return renderData1;
        }

        public static String identifier(ArmourerBlockEntity blockEntity) {
            BlockPos pos = blockEntity.m_58899_();
            return String.format("aw-armourer-%d-%d-%d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }

        protected void finalize() throws Throwable {
            Minecraft.m_91087_().m_91097_().m_118513_(this.displayTextureLocation);
            super.finalize();
        }

        public void tick() {
            this.displayTexture.setRefer(TextureUtils.getPlayerTextureLocation(this.blockEntity.getTextureDescriptor()));
            this.displayTexture.setPaintData(this.blockEntity.getPaintData());
        }

        @Override
        public boolean shouldRenderOverlay(ISkinProperty<Boolean> property) {
            if (this.shouldRenderOverlay) {
                return this.skinProperties.get(property) == false;
            }
            return false;
        }
    }
}

