/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.undo;

import java.util.Stack;
import moe.plushie.armourers_workshop.api.action.IUndoAction;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.network.chat.Component;

public class UndoStack {
    private final Stack<IUndoAction> undoStack = new Stack();
    private final Stack<IUndoAction> redoStack = new Stack();

    public IUndoAction undo() throws Exception {
        if (this.undoStack.isEmpty()) {
            throw new CommandRuntimeException((Component)Component.m_237115_((String)"chat.armourers_workshop.undo.outOfUndos"));
        }
        IUndoAction changes = this.undoStack.peek();
        this.redoStack.push(changes.apply());
        this.undoStack.pop();
        return changes;
    }

    public IUndoAction redo() throws Exception {
        if (this.redoStack.isEmpty()) {
            throw new CommandRuntimeException((Component)Component.m_237115_((String)"chat.armourers_workshop.undo.outOfRedos"));
        }
        IUndoAction changes = this.redoStack.peek();
        this.undoStack.push(changes.apply());
        this.redoStack.pop();
        return changes;
    }

    public void push(IUndoAction action) {
        this.undoStack.push(action);
        this.redoStack.clear();
        while (!this.undoStack.isEmpty() && this.undoStack.size() > ModConfig.Common.maxUndos) {
            this.undoStack.removeElementAt(0);
        }
    }

    public void clear() {
        this.undoStack.clear();
        this.redoStack.clear();
    }
}

