/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import moe.plushie.armourers_workshop.api.action.IUndoAction;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.UndoStack;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class UndoActionPacket
extends CustomPacket {
    private final boolean isRedo;

    public UndoActionPacket(FriendlyByteBuf buffer) {
        this.isRedo = buffer.readBoolean();
    }

    public UndoActionPacket(boolean isRedo) {
        this.isRedo = isRedo;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isRedo);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        try {
            MutableComponent message;
            UndoStack stack = UndoManager.of(player.m_20148_());
            if (this.isRedo) {
                if (!ModPermissions.REDO.accept((Player)player)) {
                    return;
                }
                IUndoAction command = stack.redo();
                message = Component.m_237110_((String)"chat.armourers_workshop.undo.redoing", (Object[])new Object[]{command.name()});
            } else {
                if (!ModPermissions.UNDO.accept((Player)player)) {
                    return;
                }
                IUndoAction command = stack.undo();
                message = Component.m_237110_((String)"chat.armourers_workshop.undo.undoing", (Object[])new Object[]{command.name()});
            }
            player.m_213846_((Component)message);
        }
        catch (CommandRuntimeException exception) {
            player.m_213846_(exception.m_79226_());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

