/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.other.CubeApplier;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.permission.BlockPermission;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateArmourerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Field field;
    private final Object fieldValue;

    public UpdateArmourerPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.field = (Field)buffer.m_130066_(Field.class);
        this.fieldValue = this.field.getDataAccessor().dataSerializer.m_6709_(buffer);
    }

    public UpdateArmourerPacket(ArmourerBlockEntity entity, Field field, Object value) {
        this.pos = entity.m_58899_();
        this.field = field;
        this.fieldValue = value;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130068_((Enum)this.field);
        this.field.getDataAccessor().dataSerializer.m_6856_(buffer, this.fieldValue);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        BlockEntity blockEntity = PropertyProvider.getLevel((Entity)player).m_7702_(this.pos);
        if (blockEntity instanceof ArmourerBlockEntity && player.f_36096_ instanceof ArmourerMenu) {
            BlockUtils.beginCombiner();
            this.acceptFieldUpdate((Player)player, (ArmourerBlockEntity)blockEntity, (ArmourerMenu)player.f_36096_);
            BlockUtils.endCombiner();
        }
    }

    private void acceptFieldUpdate(Player player, ArmourerBlockEntity blockEntity, ArmourerMenu container) {
        String playerName = player.m_5446_().getString();
        if (!this.field.permission.accept(blockEntity, player)) {
            return;
        }
        switch (this.field) {
            case ITEM_LOAD: {
                container.loadArmourItem(player);
                break;
            }
            case ITEM_SAVE: {
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                ModLog.info("accept save action of the {}, nbt: {}", playerName, nbt);
                GameProfile profile = DataSerializers.readGameProfile(nbt);
                container.saveArmourItem(player, profile, null, null);
                break;
            }
            case ITEM_CLEAR: {
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                ModLog.info("accept clear action of the {}, nbt: {}", playerName, nbt);
                CubeApplier applier = new CubeApplier(blockEntity.m_58904_());
                ISkinPartType partType = SkinPartTypes.byName(nbt.m_128461_("PartType"));
                if (nbt.m_128471_("Cubes")) {
                    blockEntity.clearCubes(applier, partType);
                }
                if (nbt.m_128471_("Paints")) {
                    blockEntity.clearPaintData(applier, partType);
                }
                if (nbt.m_128471_("Markers") && !nbt.m_128471_("Cubes")) {
                    blockEntity.clearMarkers(applier, partType);
                }
                applier.submit((Component)Component.m_237115_((String)"action.armourers_workshop.block.clear"), player);
                break;
            }
            case ITEM_COPY: {
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                ModLog.info("accept copy action of the {}, nbt: {}", playerName, nbt);
                try {
                    boolean isMirror = nbt.m_128471_("Mirror");
                    boolean isCopyPaintData = nbt.m_128471_("Paints");
                    ISkinPartType sourcePartType = SkinPartTypes.byName(nbt.m_128461_("Source"));
                    ISkinPartType destinationPartType = SkinPartTypes.byName(nbt.m_128461_("Destination"));
                    CubeApplier applier = new CubeApplier(blockEntity.m_58904_());
                    blockEntity.copyCubes(applier, sourcePartType, destinationPartType, isMirror);
                    if (isCopyPaintData) {
                        blockEntity.copyPaintData(applier, sourcePartType, destinationPartType, isMirror);
                    }
                    applier.submit((Component)Component.m_237115_((String)"action.armourers_workshop.block.copy"), player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case ITEM_REPLACE: {
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                ModLog.info("accept replace action of the {}, nbt: {}", playerName, nbt);
                try {
                    ItemStack source = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Source"));
                    ItemStack destination = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Destination"));
                    CubeReplacingEvent event = new CubeReplacingEvent(source, destination);
                    event.keepColor = nbt.m_128471_("KeepColor");
                    event.keepPaintType = nbt.m_128471_("KeepPaintType");
                    if (event.isEmptySource && event.isEmptyDestination) {
                        return;
                    }
                    CubeApplier applier = new CubeApplier(blockEntity.m_58904_());
                    blockEntity.replaceCubes(applier, SkinPartTypes.UNKNOWN, event);
                    applier.submit((Component)Component.m_237115_((String)"action.armourers_workshop.block.replace"), player);
                    player.m_213846_((Component)Component.m_237110_((String)"inventory.armourers_workshop.armourer.dialog.replace.success", (Object[])new Object[]{applier.getChanges()}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                this.field.set(blockEntity, this.fieldValue);
            }
        }
    }

    public static enum Field {
        FLAGS(DataSerializers.INT, ArmourerBlockEntity::getFlags, ArmourerBlockEntity::setFlags, ModPermissions.ARMOURER_SETTING),
        SKIN_TYPE(DataSerializers.SKIN_TYPE, ArmourerBlockEntity::getSkinType, ArmourerBlockEntity::setSkinType, ModPermissions.ARMOURER_SETTING),
        SKIN_PROPERTIES(DataSerializers.SKIN_PROPERTIES, ArmourerBlockEntity::getSkinProperties, ArmourerBlockEntity::setSkinProperties, ModPermissions.ARMOURER_SETTING),
        TEXTURE_DESCRIPTOR(DataSerializers.PLAYER_TEXTURE, ArmourerBlockEntity::getTextureDescriptor, ArmourerBlockEntity::setTextureDescriptor, ModPermissions.ARMOURER_SETTING),
        ITEM_CLEAR(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_CLEAR),
        ITEM_COPY(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_COPY),
        ITEM_REPLACE(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_REPLACE),
        ITEM_LOAD(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_LOAD),
        ITEM_SAVE(DataSerializers.COMPOUND_TAG, null, null, ModPermissions.ARMOURER_SAVE);

        public final BlockPermission permission;
        private final DataAccessor<ArmourerBlockEntity, ?> dataAccessor;

        private <T> Field(IEntitySerializer<T> dataSerializer, Function<ArmourerBlockEntity, T> supplier, BiConsumer<ArmourerBlockEntity, T> applier, BlockPermission permission) {
            this.permission = permission;
            this.dataAccessor = DataAccessor.of(dataSerializer, supplier, applier);
        }

        public <T> T get(ArmourerBlockEntity entity) {
            DataAccessor<ArmourerBlockEntity, T> dataAccessor = this.getDataAccessor();
            return dataAccessor.get(entity);
        }

        public <T> void set(ArmourerBlockEntity entity, T value) {
            DataAccessor<ArmourerBlockEntity, T> dataAccessor = this.getDataAccessor();
            dataAccessor.set(entity, value);
        }

        public <T> DataAccessor<ArmourerBlockEntity, T> getDataAccessor() {
            return (DataAccessor)ObjectUtils.unsafeCast(this.dataAccessor);
        }

        public BlockPermission getPermission() {
            return this.permission;
        }
    }
}

