/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.blockentity.BoundingBoxBlockEntity;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.other.CubeApplier;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.color.TexturedPaintColor;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CubePaintingEvent {
    private static final HashMap<Class<? extends Action>, ActionTypes> REVERSE_LOOKUP = new HashMap();
    final IPaintToolAction action;
    final IPaintToolSelector selector;
    final HashMap<Pair<BlockPos, Direction>, IPaintToolAction> overrides = new HashMap();
    private int targetCount = 0;

    public CubePaintingEvent(IPaintToolSelector selector, IPaintToolAction action) {
        this.selector = selector;
        this.action = action;
    }

    public CubePaintingEvent(FriendlyByteBuf buffer) {
        int size;
        this.selector = CubeSelector.from(buffer);
        this.action = Action.fromBuffer(buffer);
        while ((size = buffer.readByte()) > 0) {
            BlockPos pos = buffer.m_130135_();
            for (int i = 0; i < size; ++i) {
                Direction dir = (Direction)buffer.m_130066_(Direction.class);
                Action action = Action.fromBuffer(buffer);
                this.overrides.put((Pair<BlockPos, Direction>)Pair.of((Object)pos, (Object)dir), action);
            }
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        this.selector.encode(buffer);
        Action.writeBuffer(this.action, buffer);
        HashMap<BlockPos, HashMap> sorted = new HashMap<BlockPos, HashMap>();
        this.overrides.forEach((pair, action) -> sorted.computeIfAbsent((BlockPos)pair.getKey(), k -> new HashMap()).put((Direction)pair.getValue(), action));
        sorted.forEach((pos, items) -> {
            buffer.writeByte(items.size());
            buffer.m_130064_(pos);
            items.forEach((dir, action) -> {
                buffer.m_130068_((Enum)dir);
                Action.writeBuffer(action, buffer);
            });
        });
        buffer.writeByte(0);
    }

    public boolean prepare(CubeApplier applier, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        this.selector.forEach(context, (target, dir) -> {
            IPaintToolAction action1;
            CubeWrapper wrapper = applier.wrap((BlockPos)target);
            if (wrapper.is(IPaintable.class)) {
                ++this.targetCount;
            }
            if ((action1 = this.action.build(level, (BlockPos)target, (Direction)dir, wrapper, player)) != this.action) {
                this.overrides.put((Pair<BlockPos, Direction>)Pair.of((Object)target, (Object)dir), action1);
            }
        });
        return this.targetCount != 0;
    }

    public void apply(CubeApplier applier, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        this.selector.forEach(context, (target, dir) -> {
            IPaintToolAction action1 = this.overrides.getOrDefault(Pair.of((Object)target, (Object)dir), this.action);
            action1.apply(level, (BlockPos)target, (Direction)dir, applier.wrap((BlockPos)target), player);
        });
    }

    public static abstract class Action
    implements IPaintToolAction {
        public static Action fromBuffer(FriendlyByteBuf buffer) {
            ActionTypes type = (ActionTypes)buffer.m_130066_(ActionTypes.class);
            return type.factory.apply(buffer);
        }

        public static void writeBuffer(IPaintToolAction action, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)ActionTypes.getType(action.getClass()));
            action.encode(buffer);
        }

        @Override
        public abstract void apply(Level var1, BlockPos var2, Direction var3, IPaintable var4, @Nullable Player var5);

        @Override
        public Action build(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            return this;
        }

        @Override
        public abstract void encode(FriendlyByteBuf var1);
    }

    public static class BlendingAction
    extends MixedAction {
        final int intensity;
        final IPaintColor destinationColor;

        public BlendingAction(IPaintColor destinationColor, int intensity) {
            this.destinationColor = destinationColor;
            this.intensity = intensity;
        }

        public BlendingAction(FriendlyByteBuf buffer) {
            this.destinationColor = PaintColor.of(buffer.readInt());
            this.intensity = buffer.readInt();
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.writeInt(this.destinationColor.getRawValue());
            buffer.writeInt(this.intensity);
        }

        @Override
        public IPaintColor resolve(BlockPos pos, Direction dir, IPaintColor sourceColor) {
            int destRGB = this.destinationColor.getRGB();
            int destR = ColorUtils.getRed(destRGB);
            int destG = ColorUtils.getGreen(destRGB);
            int destB = ColorUtils.getBlue(destRGB);
            int sourceRGB = sourceColor.getRGB();
            int oldR = ColorUtils.getRed(sourceRGB);
            int oldG = ColorUtils.getGreen(sourceRGB);
            int oldB = ColorUtils.getBlue(sourceRGB);
            float newR = (float)destR / 100.0f * (float)this.intensity;
            newR += (float)oldR / 100.0f * (float)(100 - this.intensity);
            newR = MathUtils.clamp((int)newR, 0, 255);
            float newG = (float)destG / 100.0f * (float)this.intensity;
            newG += (float)oldG / 100.0f * (float)(100 - this.intensity);
            newG = MathUtils.clamp((int)newG, 0, 255);
            float newB = (float)destB / 100.0f * (float)this.intensity;
            newB += (float)oldB / 100.0f * (float)(100 - this.intensity);
            newB = MathUtils.clamp((int)newB, 0, 255);
            return PaintColor.of(ColorUtils.getRGB((int)newR, (int)newG, (int)newB), sourceColor.getPaintType());
        }
    }

    public static class HueAction
    extends MixedAction {
        final IPaintColor destinationColor;
        final boolean changeHue;
        final boolean changeSaturation;
        final boolean changeBrightness;
        final boolean changePaintType;

        public HueAction(IPaintColor paintColor, boolean hue, boolean saturation, boolean brightness, boolean paintType) {
            this.destinationColor = paintColor;
            this.changeHue = hue;
            this.changeSaturation = saturation;
            this.changeBrightness = brightness;
            this.changePaintType = paintType;
        }

        public HueAction(FriendlyByteBuf buffer) {
            this.destinationColor = PaintColor.of(buffer.readInt());
            this.changeHue = buffer.readBoolean();
            this.changeSaturation = buffer.readBoolean();
            this.changeBrightness = buffer.readBoolean();
            this.changePaintType = buffer.readBoolean();
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.writeInt(this.destinationColor.getRawValue());
            buffer.writeBoolean(this.changeHue);
            buffer.writeBoolean(this.changeSaturation);
            buffer.writeBoolean(this.changeBrightness);
            buffer.writeBoolean(this.changePaintType);
        }

        @Override
        public IPaintColor resolve(BlockPos pos, Direction dir, IPaintColor sourceColor) {
            float[] sourceHSB = ColorUtils.RGBtoHSB(sourceColor);
            float[] destinationHSB = ColorUtils.RGBtoHSB(this.destinationColor);
            if (!this.changeHue) {
                destinationHSB[0] = sourceHSB[0];
            }
            if (!this.changeSaturation) {
                destinationHSB[1] = sourceHSB[1];
            }
            if (!this.changeBrightness) {
                destinationHSB[2] = sourceHSB[2];
            }
            int rgb = ColorUtils.HSBtoRGB(destinationHSB);
            if (!this.changePaintType) {
                return PaintColor.of(rgb, sourceColor.getPaintType());
            }
            return PaintColor.of(rgb, this.destinationColor.getPaintType());
        }
    }

    public static class NoiseAction
    extends MixedAction {
        final int intensity;
        final boolean isShadeOnly;
        final int seed;
        final Random random = new Random();

        public NoiseAction(int intensity, boolean isShadeOnly) {
            this.intensity = intensity;
            this.isShadeOnly = isShadeOnly;
            this.seed = this.random.nextInt();
        }

        public NoiseAction(FriendlyByteBuf buffer) {
            this.intensity = buffer.readInt();
            this.isShadeOnly = buffer.readBoolean();
            this.seed = buffer.readInt();
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.writeInt(this.intensity);
            buffer.writeBoolean(this.isShadeOnly);
            buffer.writeInt(this.seed);
        }

        @Override
        public IPaintColor resolve(BlockPos pos, Direction dir, IPaintColor sourceColor) {
            int rgb = sourceColor.getRGB();
            rgb = this.isShadeOnly ? ColorUtils.addShadeNoise(rgb, this.intensity, this.getRandom(pos, dir)) : ColorUtils.addColorNoise(rgb, this.intensity, this.getRandom(pos, dir));
            return PaintColor.of(rgb, sourceColor.getPaintType());
        }

        private Random getRandom(BlockPos pos, Direction dir) {
            this.random.setSeed(pos.m_121878_() + ((long)this.seed << dir.ordinal()));
            return this.random;
        }
    }

    public static class BrightnessAction
    extends MixedAction {
        final int intensity;

        public BrightnessAction(int intensity) {
            this.intensity = intensity;
        }

        public BrightnessAction(FriendlyByteBuf buffer) {
            this.intensity = buffer.readInt();
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.writeInt(this.intensity);
        }

        @Override
        public IPaintColor resolve(BlockPos pos, Direction dir, IPaintColor sourceColor) {
            int rgb = sourceColor.getRGB();
            rgb = ColorUtils.makeColorBighter(rgb, this.intensity);
            return PaintColor.of(rgb, sourceColor.getPaintType());
        }
    }

    public static class ClearAction
    extends Action {
        public ClearAction() {
        }

        public ClearAction(FriendlyByteBuf buffer) {
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
        }

        @Override
        public void apply(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            if (provider.shouldChangeColor(dir)) {
                if (level.m_7702_(pos) instanceof BoundingBoxBlockEntity) {
                    provider.setColor(dir, PaintColor.CLEAR);
                } else {
                    provider.setColor(dir, PaintColor.WHITE);
                }
            }
        }
    }

    public static class SetAction
    extends Action {
        final IPaintColor destinationColor;

        public SetAction(IPaintColor paintColor) {
            this.destinationColor = paintColor;
        }

        public SetAction(FriendlyByteBuf buffer) {
            this.destinationColor = PaintColor.of(buffer.readInt());
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            buffer.writeInt(this.destinationColor.getRawValue());
        }

        @Override
        public void apply(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            if (provider.shouldChangeColor(dir)) {
                provider.setColor(dir, this.destinationColor);
            }
        }
    }

    public static abstract class MixedAction
    extends Action {
        public abstract IPaintColor resolve(BlockPos var1, Direction var2, IPaintColor var3);

        @Override
        public Action build(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            IPaintColor paintColor;
            if (provider.shouldChangeColor(dir) && (paintColor = provider.getColor(dir)) instanceof TexturedPaintColor) {
                return new SetAction(this.resolve(pos, dir, paintColor));
            }
            return this;
        }

        @Override
        public void apply(Level level, BlockPos pos, Direction dir, IPaintable provider, @Nullable Player player) {
            if (provider.shouldChangeColor(dir)) {
                provider.setColor(dir, this.resolve(pos, dir, provider.getColor(dir)));
            }
        }
    }

    public static enum ActionTypes {
        SET_COLOR(SetAction.class, SetAction::new),
        SET_BRIGHTNESS(BrightnessAction.class, BrightnessAction::new),
        SET_NOISE(NoiseAction.class, NoiseAction::new),
        SET_HUE(HueAction.class, HueAction::new),
        SET_BLENDING(BlendingAction.class, BlendingAction::new),
        CLEAR_COLOR(ClearAction.class, ClearAction::new);

        private final Function<FriendlyByteBuf, Action> factory;

        private ActionTypes(Class<? extends Action> packetClass, Function<FriendlyByteBuf, Action> factory) {
            this.factory = factory;
            REVERSE_LOOKUP.put(packetClass, this);
        }

        public static ActionTypes getType(Class<?> c) {
            return REVERSE_LOOKUP.get(c);
        }
    }
}

