/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;

public class CubeTransform {
    public final Level level;
    public final BlockPos blockPos;
    public final Direction direction;
    public final Rotation rotation;
    public final Rotation invRotation;
    public final OpenQuaternionf rotationDegrees;

    public CubeTransform(Level level, BlockPos blockPos, Direction direction) {
        this.level = level;
        this.blockPos = blockPos;
        this.direction = direction;
        this.rotation = CubeTransform.getRotation(direction, false);
        this.invRotation = CubeTransform.getRotation(direction, true);
        this.rotationDegrees = CubeTransform.getRotationDegrees(direction);
    }

    public static Rotation getRotation(Direction dir, boolean flags) {
        switch (dir) {
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                if (flags) {
                    return Rotation.CLOCKWISE_90;
                }
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case EAST: {
                if (flags) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                return Rotation.CLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static OpenQuaternionf getRotationDegrees(Direction dir) {
        switch (dir) {
            case SOUTH: {
                return new OpenQuaternionf(0.0f, 180.0f, 0.0f, true);
            }
            case WEST: {
                return new OpenQuaternionf(0.0f, 90.0f, 0.0f, true);
            }
            case EAST: {
                return new OpenQuaternionf(0.0f, -90.0f, 0.0f, true);
            }
        }
        return OpenQuaternionf.ONE;
    }

    public Direction rotate(Direction dir) {
        return this.rotation.m_55954_(dir);
    }

    public Direction invRotate(Direction dir) {
        return this.invRotation.m_55954_(dir);
    }

    public BlockPos mul(Vector3i pos) {
        return this.mul(pos.getX(), pos.getY(), pos.getZ());
    }

    public BlockPos mul(int x, int y, int z) {
        if (this.rotationDegrees == OpenQuaternionf.ONE) {
            return this.blockPos.m_7918_(x, y, z);
        }
        Vector4f off = new Vector4f((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, 1.0f);
        off.transform(this.rotationDegrees);
        return this.blockPos.m_7918_(MathUtils.floor(off.x()), MathUtils.floor(off.y()), MathUtils.floor(off.z()));
    }
}

