/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility;

import java.util.stream.Collectors;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractSkinnableModels;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.model.geom.ModelPart.SafeChild;
import moe.plushie.armourers_workshop.core.client.model.CachedModel;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractModelPartRegistries {
    public static void init() {
        ModelHolder.register(EntityModel.class, CachedModel::new, (model, it) -> {});
        ModelHolder.register(HierarchicalModel.class, (model, it) -> it.unnamed(model.m_142109_().m_171331_().collect(Collectors.toList())));
        ModelHolder.register(AbstractSkinnableModels.HUMANOID, CachedModel.Humanoid::new, (model, it) -> {
            it.put("hat", model.f_102809_);
            it.put("head", model.f_102808_);
            it.put("body", model.f_102810_);
            it.put("left_arm", model.f_102812_);
            it.put("right_arm", model.f_102811_);
            it.put("left_leg", model.f_102814_);
            it.put("right_leg", model.f_102813_);
        });
        ModelHolder.register(AbstractSkinnableModels.PLAYER, CachedModel.Player::new, (model, it) -> {
            it.put("left_sleeve", model.f_103374_);
            it.put("right_sleeve", model.f_103375_);
            it.put("left_pants", model.f_103376_);
            it.put("right_pants", model.f_103377_);
            it.put("jacket", model.f_103378_);
            it.put("cloak", model.f_103373_);
            it.put("ear", model.f_103379_);
        });
        ModelHolder.register(AbstractSkinnableModels.CREEPER, (model, it) -> {
            ModelPart root = model.m_142109_();
            it.put("head", SafeChild.getSafeChild(root, "head"));
            it.put("hair", SafeChild.getSafeChild(root, "head"));
        });
        ModelHolder.register(AbstractSkinnableModels.CHICKEN, (model, it) -> {
            it.put("head", model.f_102381_);
            it.put("beak", model.f_102387_);
            it.put("red_thing", model.f_102388_);
        });
        ModelHolder.register(AbstractSkinnableModels.VILLAGER, CachedModel.Humanoid::new, (model, it) -> {
            ModelPart root = model.m_142109_();
            ModelPart head = SafeChild.getSafeChild(root, "head");
            ModelPart hat = SafeChild.getSafeChild(head, "hat");
            ModelPart body = SafeChild.getSafeChild(root, "body");
            it.put("hat", hat);
            it.put("hat_rim", SafeChild.getSafeChild(hat, "hat_rim"));
            it.put("head", head);
            it.put("nose", SafeChild.getSafeChild(head, "nose"));
            it.put("body", body);
            it.put("left_arm", SafeChild.getSafeChild(root, "arms"));
            it.put("right_arm", SafeChild.getSafeChild(root, "arms"));
            it.put("left_leg", SafeChild.getSafeChild(root, "left_leg"));
            it.put("right_leg", SafeChild.getSafeChild(root, "right_leg"));
            it.put("jacket", SafeChild.getSafeChild(body, "jacket"));
        });
        ModelHolder.register(AbstractSkinnableModels.ILLAGER, CachedModel.Humanoid::new, (model, it) -> {
            ModelPart root = model.m_142109_();
            ModelPart head = SafeChild.getSafeChild(root, "head");
            ModelPart hat = SafeChild.getSafeChild(head, "hat");
            it.put("hat", hat);
            it.put("head", head);
            it.put("body", SafeChild.getSafeChild(root, "body"));
            it.put("arms", SafeChild.getSafeChild(root, "arms"));
            it.put("left_arm", SafeChild.getSafeChild(root, "left_arm"));
            it.put("right_arm", SafeChild.getSafeChild(root, "right_arm"));
            it.put("left_leg", SafeChild.getSafeChild(root, "left_leg"));
            it.put("right_leg", SafeChild.getSafeChild(root, "right_leg"));
        });
        ModelHolder.register(AbstractSkinnableModels.IRON_GOLE, CachedModel.Humanoid::new, (model, it) -> {
            ModelPart root = model.m_142109_();
            it.put("hat", SafeChild.getSafeChild(root, "head"));
            it.put("head", SafeChild.getSafeChild(root, "head"));
            it.put("body", SafeChild.getSafeChild(root, "body"));
            it.put("left_arm", SafeChild.getSafeChild(root, "left_arm"));
            it.put("right_arm", SafeChild.getSafeChild(root, "right_arm"));
            it.put("left_leg", SafeChild.getSafeChild(root, "left_leg"));
            it.put("right_leg", SafeChild.getSafeChild(root, "right_leg"));
        });
        ModelHolder.registerOptional(AbstractSkinnableModels.ALLAY, CachedModel.Humanoid::new, (model, it) -> {
            ModelPart root = model.m_142109_();
            ModelPart body = SafeChild.getSafeChild(root, "body");
            it.put("root", root);
            it.put("hat", SafeChild.getSafeChild(root, "head"));
            it.put("head", SafeChild.getSafeChild(root, "head"));
            it.put("body", SafeChild.getSafeChild(root, "body"));
            it.put("left_arm", SafeChild.getSafeChild(body, "left_arm"));
            it.put("right_arm", SafeChild.getSafeChild(body, "right_arm"));
            it.put("left_leg", SafeChild.getSafeChild(body, "left_wing"));
            it.put("right_leg", SafeChild.getSafeChild(body, "right_wing"));
            it.put("left_wing", SafeChild.getSafeChild(body, "left_wing"));
            it.put("right_wing", SafeChild.getSafeChild(body, "right_wing"));
        });
    }
}

