/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGGraphicsRenderer;
import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIFont;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class AbstractGraphicsRenderer
implements CGGraphicsRenderer,
CGGraphicsState {
    private final GuiGraphics graphics;
    private final CGPoint mousePos;
    private final float partialTicks;
    private final Font font;
    private UIFont uifont;

    public AbstractGraphicsRenderer(Font font, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.font = font;
        this.graphics = graphics;
        this.mousePos = new CGPoint(mouseX, mouseY);
        this.partialTicks = partialTicks;
    }

    public static GuiGraphics of(CGGraphicsContext context) {
        AbstractGraphicsRenderer impl = (AbstractGraphicsRenderer)ObjectUtils.unsafeCast(context.state());
        return impl.graphics;
    }

    public static CGGraphicsContext of(Font font, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        AbstractGraphicsRenderer impl = new AbstractGraphicsRenderer(font, graphics, mouseX, mouseY, partialTicks);
        return new CGGraphicsContext(impl, impl);
    }

    @Override
    public void renderTooltip(NSString text, CGRect rect, @Nullable UIFont font, CGGraphicsContext context) {
        if (font == null) {
            font = context.state().font();
        }
        Font font1 = font.impl();
        List texts = font1.m_92923_((FormattedText)text.component(), 100000);
        this.graphics.m_280245_(font1, texts, (int)this.mousePos.getX(), (int)this.mousePos.getY());
    }

    @Override
    public void renderEntity(LivingEntity entity, int x, int y, int scale, float mouseX, float mouseY, CGGraphicsContext context) {
        InventoryScreen.m_274545_((GuiGraphics)this.graphics, (int)x, (int)y, (int)scale, (float)mouseX, (float)mouseY, (LivingEntity)entity);
    }

    @Override
    public void renderItem(ItemStack itemStack, int x, int y, CGGraphicsContext context) {
        this.graphics.m_280203_(itemStack, x, y);
    }

    @Override
    public void flush() {
        this.graphics.m_280262_();
    }

    @Override
    public CGPoint mousePos() {
        return this.mousePos;
    }

    @Override
    public float partialTicks() {
        return this.partialTicks;
    }

    @Override
    public UIFont font() {
        if (this.uifont == null) {
            this.uifont = new UIFont(this.font, 9.0f);
        }
        return this.uifont;
    }

    @Override
    public MultiBufferSource buffers() {
        return this.graphics.m_280091_();
    }

    @Override
    public PoseStack ctm() {
        return this.graphics.m_280168_();
    }
}

