/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.ILootContext;
import moe.plushie.armourers_workshop.api.common.ILootContextParam;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHorizontalBlockImpl
extends HorizontalDirectionalBlock {
    public AbstractHorizontalBlockImpl(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public final List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        return this.getDrops(blockState, new LootContextBuilder(builder));
    }

    public List<ItemStack> getDrops(BlockState blockState, ILootContext context) {
        return super.m_49635_(blockState, ((LootContextBuilder)context).builder);
    }

    public static class LootContextBuilder
    implements ILootContext {
        private static final ImmutableMap<ILootContextParam<?>, LootContextParam<?>> KEYS = ImmutableMap.builder().put(ILootContextParam.THIS_ENTITY, (Object)LootContextParams.f_81455_).put(ILootContextParam.LAST_DAMAGE_PLAYER, (Object)LootContextParams.f_81456_).put(ILootContextParam.DAMAGE_SOURCE, (Object)LootContextParams.f_81457_).put(ILootContextParam.KILLER_ENTITY, (Object)LootContextParams.f_81458_).put(ILootContextParam.DIRECT_KILLER_ENTITY, (Object)LootContextParams.f_81459_).put(ILootContextParam.ORIGIN, (Object)LootContextParams.f_81460_).put(ILootContextParam.BLOCK_STATE, (Object)LootContextParams.f_81461_).put(ILootContextParam.BLOCK_ENTITY, (Object)LootContextParams.f_81462_).put(ILootContextParam.TOOL, (Object)LootContextParams.f_81463_).put(ILootContextParam.EXPLOSION_RADIUS, (Object)LootContextParams.f_81464_).build();
        private final LootParams.Builder builder;

        public LootContextBuilder(LootParams.Builder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T getParameter(ILootContextParam<T> param) {
            Object value = this.builder.m_287261_((LootContextParam)KEYS.get(param));
            return param.getValueClass().cast(this.convert(value));
        }

        @Override
        @Nullable
        public <T> T getOptionalParameter(ILootContextParam<T> param) {
            Object value = this.builder.m_287159_((LootContextParam)KEYS.get(param));
            if (value != null) {
                return param.getValueClass().cast(this.convert(value));
            }
            return null;
        }

        private Object convert(Object value) {
            Vec3 pos = ObjectUtils.safeCast(value, Vec3.class);
            if (pos != null) {
                return new Vector3f((float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_);
            }
            return value;
        }
    }
}

