/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack;

import com.mojang.blaze3d.vertex.PoseStack;
import java.nio.FloatBuffer;
import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import moe.plushie.armourers_workshop.api.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.math.IQuaternionf;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Extension
public class ABI {
    private static final Matrix3f CONVERTER_MAT3 = new Matrix3f();
    private static final Matrix4f CONVERTER_MAT4 = new Matrix4f();
    private static final FloatBuffer BUFFER3x3 = ObjectUtils.createFloatBuffer(9);
    private static final FloatBuffer BUFFER4x4 = ObjectUtils.createFloatBuffer(16);

    public static PoseStack copy(@This PoseStack poseStack) {
        PoseStack poseStack1 = new PoseStack();
        poseStack1.m_85850_().m_252922_().set((Matrix4fc)poseStack.m_85850_().m_252922_());
        poseStack1.m_85850_().m_252943_().set((Matrix3fc)poseStack.m_85850_().m_252943_());
        return poseStack1;
    }

    public static void mulPose(@This PoseStack poseStack, IQuaternionf q) {
        poseStack.m_252781_(new Quaternionf(q.x(), q.y(), q.z(), q.w()));
    }

    public static void mulPoseMatrix(@This PoseStack poseStack, IMatrix4f matrix) {
        poseStack.m_252931_(Mat4.convertMatrix(matrix));
    }

    public static void mulNormalMatrix(@This PoseStack poseStack, IMatrix3f matrix) {
        poseStack.m_85850_().m_252943_().mul((Matrix3fc)Mat3.convertMatrix(matrix));
    }

    public static IMatrix4f lastPose(@This PoseStack poseStack) {
        return new Mat4(poseStack.m_85850_().m_252922_());
    }

    public static IMatrix3f lastNormal(@This PoseStack poseStack) {
        return new Mat3(poseStack.m_85850_().m_252943_());
    }

    public static class Mat4
    implements IMatrix4f {
        private final Matrix4f mat;

        public Mat4(Matrix4f mat) {
            this.mat = mat;
        }

        @Override
        public void load(FloatBuffer buffer) {
            this.mat.set(buffer);
        }

        @Override
        public void store(FloatBuffer buffer) {
            this.mat.get(buffer);
        }

        @Override
        public void scale(float x, float y, float z) {
            this.mat.scale(x, y, z);
        }

        @Override
        public void translate(float x, float y, float z) {
            this.mat.translate(x, y, z);
        }

        @Override
        public void rotate(IQuaternionf q) {
            this.mat.rotate((Quaternionfc)new Quaternionf(q.x(), q.y(), q.z(), q.w()));
        }

        @Override
        public void multiply(IMatrix4f matrix) {
            this.mat.mul((Matrix4fc)Mat4.convertMatrix(matrix));
        }

        @Override
        public void multiply(float[] values) {
            Vector4f vec = new Vector4f(values[0], values[1], values[2], values[3]);
            vec.mul((Matrix4fc)this.mat);
            values[0] = vec.x();
            values[1] = vec.y();
            values[2] = vec.z();
            values[3] = vec.w();
        }

        @Override
        public void invert() {
            this.mat.invert();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Mat4)) {
                return false;
            }
            Mat4 that = (Mat4)o;
            return this.mat.equals((Object)that.mat);
        }

        public int hashCode() {
            return this.mat.hashCode();
        }

        public static Matrix4f convertMatrix(IMatrix4f mat) {
            Matrix4f newValue = ObjectUtils.safeCast(mat, Matrix4f.class);
            if (newValue != null) {
                return newValue;
            }
            mat.store(BUFFER4x4);
            CONVERTER_MAT4.set(BUFFER4x4);
            return CONVERTER_MAT4;
        }
    }

    public static class Mat3
    implements IMatrix3f {
        private final Matrix3f mat;

        public Mat3(Matrix3f mat) {
            this.mat = mat;
        }

        @Override
        public void load(FloatBuffer buffer) {
            this.mat.set(buffer);
        }

        @Override
        public void store(FloatBuffer buffer) {
            this.mat.get(buffer);
        }

        @Override
        public void scale(float x, float y, float z) {
            this.mat.scale(x, y, z);
        }

        @Override
        public void rotate(IQuaternionf q) {
            this.mat.rotate((Quaternionfc)new Quaternionf(q.x(), q.y(), q.z(), q.w()));
        }

        @Override
        public void multiply(IMatrix3f matrix) {
            this.mat.mul((Matrix3fc)Mat3.convertMatrix(matrix));
        }

        @Override
        public void multiply(float[] values) {
            Vector3f vec = new Vector3f(values[0], values[1], values[2]);
            vec.mul((Matrix3fc)this.mat);
            values[0] = vec.x();
            values[1] = vec.y();
            values[2] = vec.z();
        }

        @Override
        public void invert() {
            this.mat.invert();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Mat3)) {
                return false;
            }
            Mat3 that = (Mat3)o;
            return this.mat.equals((Object)that.mat);
        }

        public int hashCode() {
            return this.mat.hashCode();
        }

        public static Matrix3f convertMatrix(IMatrix3f mat) {
            Matrix3f newValue = ObjectUtils.safeCast(mat, Matrix3f.class);
            if (newValue != null) {
                return newValue;
            }
            mat.store(BUFFER3x3);
            CONVERTER_MAT3.set(BUFFER3x3);
            return CONVERTER_MAT3;
        }
    }
}

