/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.UUID;
import moe.plushie.armourers_workshop.api.permission.IPermissionContext;
import moe.plushie.armourers_workshop.api.permission.IPermissionNode;
import moe.plushie.armourers_workshop.core.permission.BlockPermissionContext;
import moe.plushie.armourers_workshop.core.permission.PlayerPermissionContext;
import moe.plushie.armourers_workshop.core.permission.TargetPermissionContext;
import moe.plushie.armourers_workshop.init.platform.forge.builder.PermissionNodeBuilderImpl;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;

public abstract class AbstractForgePermissionManager {
    private static final ArrayList<PermissionNode<?>> PENDING = AbstractForgePermissionManager.makeRegisterQueue();
    private static final PermissionDynamicContextKey<Entity> TARGET = new PermissionDynamicContextKey(Entity.class, "target", Object::toString);
    private static final PermissionDynamicContextKey<Player> PLAYER = new PermissionDynamicContextKey(Player.class, "player", Object::toString);
    private static final PermissionDynamicContextKey<BlockPos> BLOCK_POS = new PermissionDynamicContextKey(BlockPos.class, "block_pos", Vec3i::m_123344_);
    private static final PermissionDynamicContextKey<BlockState> BLOCK_STATE = new PermissionDynamicContextKey(BlockState.class, "block_state", Object::toString);
    private static final PermissionDynamicContextKey<Direction> FACING = new PermissionDynamicContextKey(Direction.class, "facing", Direction::m_7912_);

    public static IPermissionNode makeNode(ResourceLocation registryName, int level) {
        final PermissionNode node = new PermissionNode(registryName, PermissionTypes.BOOLEAN, (player, uuid, contexts) -> true, new PermissionDynamicContextKey[]{TARGET, PLAYER, BLOCK_POS, BLOCK_STATE, FACING});
        PermissionNodeBuilderImpl.NodeImpl nodeImpl = new PermissionNodeBuilderImpl.NodeImpl(registryName){

            @Override
            public boolean resolve(Player player, IPermissionContext context) {
                if (!AbstractForgePermissionManager.hasPermissionAPI()) {
                    return true;
                }
                if (player instanceof ServerPlayer) {
                    return (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), (PermissionNode)node, AbstractForgePermissionManager.makeContexts(context));
                }
                return super.resolve(player, context);
            }

            @Override
            public boolean resolve(GameProfile profile, IPermissionContext context) {
                if (!AbstractForgePermissionManager.hasPermissionAPI()) {
                    return true;
                }
                return (Boolean)PermissionAPI.getOfflinePermission((UUID)profile.getId(), (PermissionNode)node, AbstractForgePermissionManager.makeContexts(context));
            }
        };
        node.setInformation(nodeImpl.getName(), nodeImpl.getDescription());
        PENDING.add(node);
        return nodeImpl;
    }

    private static PermissionDynamicContext<?>[] makeContexts(IPermissionContext context) {
        BlockPermissionContext block;
        TargetPermissionContext target;
        ArrayList<PermissionDynamicContext> contexts = new ArrayList<PermissionDynamicContext>();
        PlayerPermissionContext player = ObjectUtils.safeCast(context, PlayerPermissionContext.class);
        if (player != null && player.player != null) {
            contexts.add(PLAYER.createContext((Object)player.player));
        }
        if ((target = ObjectUtils.safeCast(context, TargetPermissionContext.class)) != null && target.target != null) {
            contexts.add(TARGET.createContext((Object)target.target));
        }
        if ((block = ObjectUtils.safeCast(context, BlockPermissionContext.class)) != null) {
            if (block.blockPos != null) {
                contexts.add(BLOCK_POS.createContext((Object)block.blockPos));
            }
            if (block.blockState != null) {
                contexts.add(BLOCK_STATE.createContext((Object)block.blockState));
            }
            if (block.facing != null) {
                contexts.add(FACING.createContext((Object)block.facing));
            }
        }
        return contexts.toArray(new PermissionDynamicContext[0]);
    }

    private static boolean hasPermissionAPI() {
        return ServerLifecycleHooks.getCurrentServer() != null;
    }

    private static ArrayList<PermissionNode<?>> makeRegisterQueue() {
        MinecraftForge.EVENT_BUS.addListener(AbstractForgePermissionManager::registerNodes);
        return new ArrayList();
    }

    private static void registerNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(PENDING);
    }
}

