/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.util.ArrayList;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.registry.IRegistry;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistryEntry;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;

public abstract class AbstractForgeRegistry<T>
implements IRegistry<T> {
    public static ArrayList<AbstractForgeRegistry<?>> INSTANCES = new ArrayList();
    private final Class<?> type;
    private final ArrayList<IRegistryKey<? extends T>> entries = new ArrayList();
    private final String typeName;

    public AbstractForgeRegistry(Class<?> type, DeferredRegister<?> deferredRegistry) {
        this.type = type;
        this.typeName = ObjectUtils.readableName(type);
        deferredRegistry.register(FMLJavaModLoadingContext.get().getModEventBus());
        INSTANCES.add(this);
    }

    @Override
    public <I extends T> IRegistryKey<I> register(String name, Supplier<? extends I> provider) {
        ResourceLocation registryName = ModConstants.key(name);
        Supplier<? extends I> object = this.deferredRegister(name, provider);
        AbstractForgeRegistryEntry<? extends I> entry = AbstractForgeRegistryEntry.of(registryName, object);
        this.entries.add(entry);
        ModLog.debug("Registering {} '{}'", this.typeName, registryName);
        return entry;
    }

    public abstract <I extends T> Supplier<I> deferredRegister(String var1, Supplier<? extends I> var2);

    @Override
    public abstract T getValue(ResourceLocation var1);

    @Override
    public abstract ResourceLocation getKey(T var1);

    @Override
    public ArrayList<IRegistryKey<? extends T>> getEntries() {
        return this.entries;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

