/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature.core;

import moe.plushie.armourers_workshop.api.client.armature.IJoint;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.core.armature.ArmatureModifier;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class AfterTransformModifier
extends ArmatureModifier {
    private final Vector3f translate;
    private final Vector3f scale;
    private final Vector3f rotate;

    public AfterTransformModifier(Vector3f translate, Vector3f scale, Vector3f rotate) {
        this.translate = translate;
        this.scale = scale;
        this.rotate = rotate;
    }

    @Override
    public ITransformf apply(IJoint joint, IModel model, ITransformf transform) {
        transform = this._translate(transform);
        transform = this._rotate(transform);
        transform = this._scale(transform);
        return transform;
    }

    private ITransformf _translate(ITransformf transform) {
        if (this.translate.equals(Vector3f.ZERO)) {
            return transform;
        }
        return poseStack -> {
            transform.apply(poseStack);
            poseStack.translate(this.translate.getX(), this.translate.getY(), this.translate.getZ());
        };
    }

    private ITransformf _rotate(ITransformf transform) {
        if (this.rotate.equals(Vector3f.ZERO)) {
            return transform;
        }
        OpenQuaternionf xRot = Vector3f.ZP.rotation(this.rotate.getX());
        OpenQuaternionf yRot = Vector3f.YP.rotation(this.rotate.getY());
        OpenQuaternionf zRot = Vector3f.XP.rotation(this.rotate.getZ());
        return poseStack -> {
            transform.apply(poseStack);
            poseStack.rotate(xRot);
            poseStack.rotate(yRot);
            poseStack.rotate(zRot);
        };
    }

    private ITransformf _scale(ITransformf transform) {
        if (this.scale.equals(Vector3f.ONE)) {
            return transform;
        }
        return poseStack -> {
            transform.apply(poseStack);
            poseStack.scale(this.scale.getX(), this.scale.getY(), this.scale.getZ());
        };
    }
}

