/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.capability;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.utils.DataFixerUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public class SkinWardrobeStorage {
    public static void saveDataFixer(SkinWardrobe wardrobe, CompoundTag nbt) {
        nbt.m_128344_("DataVersion", (byte)1);
    }

    public static void loadDataFixer(SkinWardrobe wardrobe, CompoundTag nbt) {
        byte version = nbt.m_128445_("DataVersion");
        if (version <= 0) {
            Container inventory = wardrobe.getInventory();
            DataFixerUtils.move(inventory, 67, SkinSlotType.DYE.getIndex(), 16, "align dye slots storage");
            DataFixerUtils.move(inventory, 57, SkinSlotType.OUTFIT.getIndex(), 10, "align outfit slots storage");
        }
    }

    public static void saveInventoryItems(Container inventory, CompoundTag nbt) {
        NonNullList itemStacks = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < itemStacks.size(); ++i) {
            itemStacks.set(i, (Object)inventory.m_8020_(i));
        }
        ContainerHelper.m_18973_((CompoundTag)nbt, (NonNullList)itemStacks);
    }

    public static void loadInventoryItems(Container inventory, CompoundTag nbt) {
        NonNullList itemStacks = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)itemStacks);
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack oldItemStack;
            ItemStack newItemStack = (ItemStack)itemStacks.get(i);
            if (Objects.equals(newItemStack, oldItemStack = inventory.m_8020_(i))) continue;
            inventory.m_6836_(i, newItemStack);
        }
    }

    public static void saveFlags(BitSet flags, CompoundTag nbt) {
        int value = 0;
        for (int i = 0; i < 32; ++i) {
            if (!flags.get(i)) continue;
            value |= 1 << i;
        }
        if (value != 0) {
            nbt.m_128405_("Visibility", value);
        }
    }

    public static void loadFlags(BitSet flags, CompoundTag nbt) {
        int value = nbt.m_128451_("Visibility");
        flags.clear();
        for (int i = 0; i < 32; ++i) {
            int mask = 1 << i;
            if ((value & mask) == 0) continue;
            flags.set(i);
        }
    }

    public static void saveSkinSlots(HashMap<SkinSlotType, Integer> slots, CompoundTag nbt) {
        if (slots.isEmpty()) {
            return;
        }
        ListTag value = new ListTag();
        slots.forEach((slotType, count) -> {
            int index = slotType.getId() & 0xFF;
            int encoded = index << 8 | count & 0xFF;
            value.add((Object)ShortTag.m_129258_((short)((short)encoded)));
        });
        if (!value.isEmpty()) {
            nbt.m_128365_("Slots", (Tag)value);
        }
    }

    public static void loadSkinSlots(HashMap<SkinSlotType, Integer> slots, CompoundTag nbt) {
        ListTag value = nbt.m_128437_("Slots", 2);
        if (value.isEmpty()) {
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            short encoded = value.m_128757_(i);
            SkinSlotType slotType = SkinSlotType.by(encoded >> 8 & 0xFF);
            if (slotType == null) continue;
            slots.put(slotType, encoded & 0xFF);
        }
    }
}

