/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.client.bake.PackedQuad;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.skin.face.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.transform.SkinPartTransform;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.utils.math.OpenRay;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkinPart {
    private final SkinPart part;
    private final PackedQuad quads;
    private final SkinPartTransform transform;
    private final ColorDescriptor descriptor;
    private final ArrayList<BakedSkinPart> children = new ArrayList();
    private int id = 0;

    public BakedSkinPart(SkinPart part, PackedQuad quads) {
        this.part = part;
        this.quads = quads;
        this.transform = new SkinPartTransform(part, quads.getTransform());
        this.descriptor = quads.getColorInfo();
    }

    public void forEach(BiConsumer<RenderType, ArrayList<SkinCubeFace>> action) {
        this.quads.forEach(action);
    }

    public void forEach(OpenRay ray, Consumer<SkinCubeFace> recorder) {
        this.quads.forEach(ray, recorder);
    }

    @Nullable
    public Object requirements(ColorScheme scheme) {
        if (this.descriptor.isEmpty() || scheme.isEmpty()) {
            return null;
        }
        boolean needsEntityTexture = false;
        ArrayList<Object> requirements = new ArrayList<Object>();
        for (ISkinPaintType paintType : this.descriptor.getPaintTypes()) {
            if (paintType.getDyeType() != null) {
                IPaintColor resolvedColor = scheme.getResolvedColor(paintType);
                requirements.add(paintType.getId());
                requirements.add(resolvedColor);
                if (resolvedColor != null) {
                    paintType = resolvedColor.getPaintType();
                }
            }
            if (paintType != SkinPaintTypes.TEXTURE) continue;
            needsEntityTexture = true;
        }
        if (needsEntityTexture && PlayerTextureLoader.getInstance().getTextureModel(scheme.getTexture()) != null) {
            requirements.add(SkinPaintTypes.TEXTURE.getId());
            requirements.add(scheme.getTexture());
        }
        return requirements;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public SkinPart getPart() {
        return this.part;
    }

    public ISkinPartType getType() {
        return this.part.getType();
    }

    public SkinPartTransform getTransform() {
        return this.transform;
    }

    public ColorDescriptor getColorInfo() {
        return this.quads.getColorInfo();
    }

    public OpenVoxelShape getRenderShape() {
        return this.quads.getRenderShape();
    }

    public int getFaceTotal() {
        return this.quads.getFaceTotal();
    }

    public float getRenderPolygonOffset() {
        if (this.part instanceof SkinPart.Empty) {
            return 20.0f;
        }
        return this.getType().getRenderPolygonOffset();
    }

    public ArrayList<BakedSkinPart> getChildren() {
        return this.children;
    }

    public SkinProperties getProperties() {
        return this.part.getProperties();
    }
}

