/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.hologramprojector;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UISliderBox;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorBaseSetting;
import moe.plushie.armourers_workshop.core.network.UpdateHologramProjectorPacket;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HologramProjectorAngleSetting
extends HologramProjectorBaseSetting {
    private UISliderBox sliderX;
    private UISliderBox sliderY;
    private UISliderBox sliderZ;
    private final HologramProjectorBlockEntity entity;
    private final UpdateHologramProjectorPacket.Field field = UpdateHologramProjectorPacket.Field.ANGLE;

    public HologramProjectorAngleSetting(HologramProjectorBlockEntity entity) {
        super("inventory.armourers_workshop.hologram-projector.angle");
        this.entity = entity;
        this.setFrame(new CGRect(0.0f, 0.0f, 200.0f, 82.0f));
        this.setup();
    }

    private void updateValue(UIControl button) {
        float x = (float)this.sliderX.value();
        float y = (float)this.sliderY.value();
        float z = (float)this.sliderZ.value();
        this.field.set(this.entity, new Vector3f(x, y, z));
    }

    private void didUpdateValue(UIControl button) {
        float x = (float)this.sliderX.value();
        float y = (float)this.sliderY.value();
        float z = (float)this.sliderZ.value();
        UpdateHologramProjectorPacket packet = new UpdateHologramProjectorPacket(this.entity, this.field, new Vector3f(x, y, z));
        NetworkManager.sendToServer(packet);
    }

    private void setup() {
        Vector3f value = (Vector3f)this.field.get(this.entity);
        this.sliderX = this.setupSlider(11, 30, "X: ", value.m_7096_());
        this.sliderY = this.setupSlider(11, 45, "Y: ", value.m_7098_());
        this.sliderZ = this.setupSlider(11, 60, "Z: ", value.m_7094_());
    }

    private UISliderBox setupSlider(int x, int y, String key, double value) {
        UISliderBox slider = new UISliderBox(new CGRect(x, y, 178.0f, 10.0f));
        slider.setMinValue(-180.0);
        slider.setMaxValue(180.0);
        slider.setFormatter(currentValue -> new NSString(String.format("%s%.2f\u00b0", key, currentValue)));
        slider.addTarget(this, UIControl.Event.VALUE_CHANGED, HologramProjectorAngleSetting::updateValue);
        slider.addTarget(this, UIControl.Event.EDITING_DID_END, HologramProjectorAngleSetting::didUpdateValue);
        slider.setValue(value);
        this.addSubview(slider);
        return slider;
    }
}

