/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.impl.InvokerResult;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIPopoverView;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BaseDialog
extends UIView {
    private Runnable completeHandler;
    protected final UILabel titleLabel = new UILabel(new CGRect(0.0f, 8.0f, 240.0f, 9.0f));

    public BaseDialog() {
        super(new CGRect(0.0f, 0.0f, 240.0f, 120.0f));
        this.setContents(ModTextures.defaultWindowImage());
        this.titleLabel.setTextHorizontalAlignment(NSTextAlignment.Horizontal.CENTER);
        this.titleLabel.setAutoresizingMask(34);
        this.addSubview(this.titleLabel);
    }

    public void dismiss() {
        UIWindow window = this.window();
        if (window instanceof UIPopoverView) {
            window.removeGlobalTarget(this, UIControl.Event.KEY_DOWN);
            ((UIPopoverView)window).dismiss();
        }
        if (this.completeHandler != null) {
            this.completeHandler.run();
            this.completeHandler = null;
        }
    }

    public void showInView(UIView view) {
        UIPopoverView popoverView = this.makePopoverView();
        popoverView.showInView(view);
        popoverView.addGlobalTarget(this, UIControl.Event.KEY_DOWN, (self, event) -> {
            if (event.key() == 256) {
                event.cancel(InvokerResult.SUCCESS);
                self.dismiss();
            }
        });
    }

    public void showInView(UIView view, Runnable completeHandler) {
        this.completeHandler = completeHandler;
        this.showInView(view);
    }

    public NSString title() {
        return this.titleLabel.text();
    }

    public void setTitle(NSString title) {
        this.titleLabel.setText(title);
    }

    protected UIPopoverView makePopoverView() {
        UIPopoverView popoverView = new UIPopoverView();
        popoverView.setContentView(this);
        return popoverView;
    }
}

