/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import com.apple.library.uikit.UIWindowManager;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreen;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContainerMenuScreen<M extends AbstractContainerMenu, W extends UIWindow>
extends AbstractMenuScreen<M> {
    private final W window;
    private final MenuWindow<?> menuWindow;
    private final UIWindowManager manager;

    public ContainerMenuScreen(W window, M menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.window = window;
        this.menuWindow = ObjectUtils.safeCast(window, MenuWindow.class);
        this.manager = new UIWindowManager();
        this.manager.addWindow((UIWindow)window);
        this.manager.init();
    }

    public void m_7856_() {
        CGSize screenSize = this.getScreenSize();
        this.manager.layout(screenSize.getWidth(), screenSize.getHeight());
        CGRect rect = ((UIView)this.window).bounds();
        this.setContentSize(new CGSize(rect.width, rect.height));
        super.m_7856_();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
    }

    public void m_181908_() {
        super.m_181908_();
        this.menuWindow.screenWillTick();
    }

    public void m_7861_() {
        super.m_7861_();
        this.manager.deinit();
    }

    @Override
    public void render(CGGraphicsContext context, int mouseX, int mouseY, float partialTicks) {
        this.manager.tick();
        this.manager.render(context, this::_render, this::_renderBackground, this::_renderTooltip);
    }

    @Override
    public void renderLabels(CGGraphicsContext context, int mouseX, int mouseY) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.manager.mouseDown(mouseX, mouseY, button, this::_mouseClicked);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.manager.mouseUp(mouseX, mouseY, button, this::_mouseReleased);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.manager.mouseWheel(mouseX, mouseY, delta, this::_mouseScrolled);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.manager.mouseMoved(mouseX, mouseY, 0, this::_mouseMoved);
    }

    public boolean m_7933_(int key, int i, int j) {
        return this.manager.keyDown(key, i, j, this::_keyPressed);
    }

    public boolean m_7920_(int key, int i, int j) {
        return this.manager.keyUp(key, i, j, this::_keyReleased);
    }

    public boolean m_5534_(char ch, int i) {
        return this.manager.charTyped(ch, i, 0, this::_charTyped);
    }

    public boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        return !this.manager.mouseIsInside(mouseX, mouseY, button);
    }

    public void m_6597_(Slot slot, int slotIndex, int j, ClickType clickType) {
        super.m_6597_(slot, slotIndex, j, clickType);
        if (slotIndex >= 0) {
            this.menuWindow.menuDidChange();
        }
    }

    @Override
    public boolean changeFocus(boolean bl) {
        return this.manager.changeKeyView(bl);
    }

    public boolean shouldRenderExtendScreen() {
        if (this.menuWindow != null) {
            return this.menuWindow.shouldRenderExtendScreen();
        }
        return false;
    }

    protected void _render(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        super.render(context, mouseX, mouseY, partialTicks);
    }

    protected void _renderTooltip(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        context.saveGraphicsState();
        context.translateCTM(0.0f, 0.0f, 400.0f);
        this.renderTooltip(context, mouseX, mouseY);
        context.restoreGraphicsState();
    }

    protected void _renderBackground(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        if (this.menuWindow != null && this.menuWindow.shouldRenderBackground()) {
            this.renderBackground(context);
        }
    }

    protected boolean _charTyped(int key, int i, int j) {
        super.m_5534_((char)key, i);
        return true;
    }

    protected boolean _keyPressed(int key, int i, int j) {
        if (this.manager.isTextEditing() && !this._editingPassKey((char)key)) {
            return false;
        }
        return super.m_7933_(key, i, j);
    }

    protected boolean _keyReleased(int key, int i, int j) {
        return super.m_7920_(key, i, j);
    }

    protected boolean _mouseClicked(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected boolean _mouseMoved(double mouseX, double mouseY, int button) {
        super.m_94757_(mouseX, mouseY);
        return true;
    }

    protected boolean _mouseScrolled(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected boolean _mouseReleased(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected boolean _editingPassKey(int key) {
        switch (key) {
            case 256: 
            case 258: {
                return true;
            }
        }
        return false;
    }
}

