/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.compatibility.AbstractRenderLayer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.armature.JointTransformModifier;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.init.ModContributors;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeLayer<T extends Entity, V extends EntityModel<T>, M extends IModel>
extends AbstractRenderLayer<T, V> {
    protected final SkinRenderer<T, M> skinRenderer;
    protected final RenderLayerParent<T, V> entityRenderer;

    public SkinWardrobeLayer(SkinRenderer<T, M> skinRenderer, RenderLayerParent<T, V> renderer) {
        super(renderer);
        this.skinRenderer = skinRenderer;
        this.entityRenderer = renderer;
    }

    public void m_6494_(PoseStack poseStack, MultiBufferSource buffers, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ModContributors.Contributor contributor;
        if (entity.m_20145_()) {
            return;
        }
        PoseStack poseStack1 = poseStack;
        Object model = ModelHolder.of((Model)this.m_117386_());
        SkinRenderData renderData = SkinRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        EpicFlightContext epicFlightContext = renderData.epicFlightContext;
        JointTransformModifier transformModifier = null;
        if (epicFlightContext != null) {
            poseStack = epicFlightContext.overridePostStack;
            transformModifier = epicFlightContext.overrideTransformModifier;
        }
        poseStack.m_85836_();
        if (epicFlightContext == null) {
            this.applyModelScale(poseStack, model);
        }
        if ((contributor = ModContributors.by(entity)) != null && renderData.shouldRenderExtra()) {
            this.renderMagicCircle(poseStack1, buffers, ((Entity)entity).f_19797_ + entity.m_19879_() * 31, partialTicks, 24, contributor.color, packedLightIn, OverlayTexture.f_118083_);
        }
        float f = 0.0625f;
        poseStack.m_85841_(f, f, f);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLightIn, TickUtils.ticks(), null, poseStack, buffers);
        context.setTransforms(transformModifier, (Entity)entity, (IModel)this.skinRenderer.getOverrideModel(model));
        for (SkinRenderData.Entry entry : renderData.getArmorSkins()) {
            context.setReference(entry.getRenderPriority(), entry.getItemStack());
            this.skinRenderer.render(entity, model, entry.getBakedSkin(), entry.getBakedScheme(), context);
        }
        context.release();
        poseStack.m_85849_();
    }

    public void renderMagicCircle(PoseStack poseStack, MultiBufferSource buffers, int ticks, float partialTickTime, int offset, int color, int lightmap, int overlay) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)offset / 16.0f, 0.0f);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        float circleScale = 2.0f;
        float rotation = (float)((double)ticks / 0.8 % 360.0) + partialTickTime;
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(rotation));
        poseStack.m_85841_(circleScale, circleScale, circleScale);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        VertexConsumer builder = buffers.m_6299_(SkinRenderType.IMAGE_MAGIC);
        builder.m_252986_(pose, -1.0f, 0.0f, -1.0f).m_6122_(red, green, blue, 255).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_5752_();
        builder.m_252986_(pose, 1.0f, 0.0f, -1.0f).m_6122_(red, green, blue, 255).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_5752_();
        builder.m_252986_(pose, 1.0f, 0.0f, 1.0f).m_6122_(red, green, blue, 255).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_5752_();
        builder.m_252986_(pose, -1.0f, 0.0f, 1.0f).m_6122_(red, green, blue, 255).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_5752_();
        poseStack.m_85849_();
    }

    protected void applyModelScale(PoseStack poseStack, M model) {
        IModelBabyPose babyPose = model.getBabyPose();
        if (babyPose != null) {
            float scale = 1.0f / babyPose.getHeadScale();
            IVector3f offset = babyPose.getHeadOffset();
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252880_(offset.getX() / 16.0f, offset.getY() / 16.0f, offset.getZ() / 16.0f);
        }
    }
}

