/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.google.common.collect.Iterators;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.armature.JointTransformModifier;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.PoseStackWrapper;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderContext {
    private static final Iterator<SkinRenderContext> POOL = Iterators.cycle(ObjectUtils.makeItems(100, i -> new SkinRenderContext(new PoseStack())));
    private int lightmap = 0xF000F0;
    private int overlay = 0;
    private float partialTicks = 0.0f;
    private MultiBufferSource buffers;
    private SkinRenderData renderData;
    private SkinRenderBufferSource bufferProvider;
    private float itemRenderPriority = 0.0f;
    private Vector3f itemRotation;
    private ItemStack itemReference = ItemStack.f_41583_;
    private ColorScheme colorScheme = ColorScheme.EMPTY;
    private AbstractItemTransformType transformType = AbstractItemTransformType.NONE;
    private ITransformf[] transforms;
    private final PoseStack defaultPoseStack;
    private final PoseStackWrapper usingPoseStack;

    public SkinRenderContext(PoseStack poseStack) {
        this.defaultPoseStack = poseStack;
        this.usingPoseStack = new PoseStackWrapper(poseStack);
    }

    public static SkinRenderContext alloc(SkinRenderData renderData, int light, float partialTick, AbstractItemTransformType transformType, PoseStack poseStack, MultiBufferSource buffers) {
        SkinRenderContext context = POOL.next();
        context.setRenderData(renderData);
        context.setLightmap(light);
        context.setPartialTicks(partialTick);
        context.setTransformType(transformType);
        context.setPose(poseStack);
        context.setBuffers(buffers);
        return context;
    }

    public static SkinRenderContext alloc(SkinRenderData renderData, int light, float partialTick, PoseStack poseStack, MultiBufferSource buffers) {
        return SkinRenderContext.alloc(renderData, light, partialTick, AbstractItemTransformType.NONE, poseStack, buffers);
    }

    public void release() {
        this.lightmap = 0xF000F0;
        this.partialTicks = 0.0f;
        this.itemReference = ItemStack.f_41583_;
        this.itemRenderPriority = 0.0f;
        this.itemRotation = null;
        this.colorScheme = ColorScheme.EMPTY;
        this.transformType = AbstractItemTransformType.NONE;
        this.usingPoseStack.set(this.defaultPoseStack);
        this.bufferProvider = null;
        this.renderData = null;
        this.buffers = null;
        this.transforms = null;
    }

    public boolean shouldRenderPart(ISkinPartType partType) {
        if (this.renderData != null && this.renderData.epicFlightContext != null && this.renderData.epicFlightContext.overrideParts != null) {
            return !this.renderData.epicFlightContext.overrideParts.contains(partType);
        }
        return true;
    }

    public void pushPose() {
        this.usingPoseStack.pushPose();
    }

    public void popPose() {
        this.usingPoseStack.popPose();
    }

    public PoseStackWrapper pose() {
        return this.usingPoseStack;
    }

    public void setLightmap(int lightmap) {
        this.lightmap = lightmap;
    }

    public int getLightmap() {
        return this.lightmap;
    }

    public void setOverlay(int overlay) {
        this.overlay = overlay;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public void setPartialTicks(float partialTicks) {
        this.partialTicks = partialTicks;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public void setTransformType(AbstractItemTransformType transformType) {
        this.transformType = transformType;
    }

    public AbstractItemTransformType getTransformType() {
        return this.transformType;
    }

    public void setTransforms(Entity entity, IModel model) {
        this.setTransforms(null, entity, model);
    }

    public void setTransforms(JointTransformModifier transformModifier, Entity entity, IModel model) {
        if (entity == null || model == null) {
            return;
        }
        if (transformModifier == null) {
            transformModifier = model.getAssociatedObject(JointTransformModifier.DEFAULT);
        }
        this.transforms = transformModifier.getTransforms(entity.m_6095_(), model);
    }

    public ITransformf[] getTransforms() {
        return this.transforms;
    }

    public void setReference(float renderPriority, ItemStack reference) {
        this.setReference(reference, renderPriority, null);
    }

    public void setReference(ItemStack reference, float renderPriority, @Nullable Vector3f rotation) {
        this.itemReference = reference;
        this.itemRotation = rotation;
        this.itemRenderPriority = renderPriority;
    }

    public ItemStack getReference() {
        return this.itemReference;
    }

    public Vector3f getReferenceRotation() {
        return this.itemRotation;
    }

    public float getRenderPriority() {
        return this.itemRenderPriority;
    }

    public void setRenderData(SkinRenderData renderData) {
        this.renderData = renderData;
    }

    public SkinRenderData getRenderData() {
        return this.renderData;
    }

    public void setPose(PoseStack pose) {
        this.usingPoseStack.set(pose);
    }

    public void setBuffers(MultiBufferSource buffers) {
        this.buffers = buffers;
    }

    public MultiBufferSource getBuffers() {
        return this.buffers;
    }

    public void setBuffer(SkinRenderBufferSource bufferProvider) {
        this.bufferProvider = bufferProvider;
    }

    public SkinRenderBufferSource.ObjectBuilder getBuffer(@NotNull Skin skin) {
        if (this.bufferProvider != null) {
            return this.bufferProvider.getBuffer(skin);
        }
        SkinVertexBufferBuilder bufferBuilder = SkinVertexBufferBuilder.getBuffer(this.buffers);
        return bufferBuilder.getBuffer(skin);
    }
}

