/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.client.IRenderAttachable;
import moe.plushie.armourers_workshop.compatibility.AbstractShader;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.RenderType.ABI;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderObjectBuilder;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexMerger;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkinVertexBufferBuilder
extends BufferBuilder
implements MultiBufferSource {
    private static SkinVertexBufferBuilder MERGED_VERTEX_BUILDER;
    protected final Pipeline pipeline = new Pipeline();
    protected final HashMap<Skin, SkinRenderObjectBuilder> cachingBuilders = new HashMap();
    protected final HashMap<RenderType, BufferBuilder> cachingBuilders2 = new HashMap();
    protected final HashMap<Skin, SkinRenderObjectBuilder> pendingBuilders = new HashMap();
    protected final HashMap<RenderType, BufferBuilder> pendingBuilders2 = new HashMap();

    public SkinVertexBufferBuilder() {
        super(256);
    }

    public static SkinVertexBufferBuilder getBuffer(MultiBufferSource buffers) {
        SkinVertexBufferBuilder.attach(buffers, Sheets.m_110789_(), SkinVertexBufferBuilder::renderSolid);
        return SkinVertexBufferBuilder.getInstance();
    }

    private static void attach(MultiBufferSource buffers, RenderType renderType, Runnable action) {
        VertexConsumer buffer = buffers.m_6299_(renderType);
        IRenderAttachable attachable = ObjectUtils.safeCast(renderType, IRenderAttachable.class);
        if (attachable != null) {
            attachable.attachRenderTask(buffer, action);
        }
    }

    public static void renderSolid() {
        SkinVertexBufferBuilder.getInstance().flush();
    }

    public static void renderTranslucent() {
        SkinVertexBufferBuilder.getInstance().flush();
    }

    public static SkinVertexBufferBuilder getInstance() {
        if (MERGED_VERTEX_BUILDER == null) {
            MERGED_VERTEX_BUILDER = new SkinVertexBufferBuilder();
        }
        return MERGED_VERTEX_BUILDER;
    }

    public static void clearAllCache() {
        SkinVertexBufferBuilder builder = SkinVertexBufferBuilder.getInstance();
        builder.cachingBuilders.clear();
        builder.cachingBuilders2.clear();
        SkinRenderObjectBuilder.clearAllCache();
    }

    @NotNull
    public VertexConsumer m_6299_(@NotNull RenderType renderType) {
        BufferBuilder buffer = this.pendingBuilders2.get(renderType);
        if (buffer != null) {
            return buffer;
        }
        buffer = this.cachingBuilders2.computeIfAbsent(renderType, k -> new BufferBuilder(k.m_110507_()));
        buffer.m_166779_(renderType.m_173186_(), renderType.m_110508_());
        this.pendingBuilders2.put(renderType, buffer);
        return buffer;
    }

    public SkinRenderObjectBuilder getBuffer(@NotNull Skin skin) {
        SkinRenderObjectBuilder bufferBuilder = this.pendingBuilders.get(skin);
        if (bufferBuilder != null) {
            return bufferBuilder;
        }
        bufferBuilder = this.cachingBuilders.computeIfAbsent(skin, SkinRenderObjectBuilder::new);
        this.pendingBuilders.put(skin, bufferBuilder);
        return bufferBuilder;
    }

    public void flush() {
        if (!this.pendingBuilders.isEmpty()) {
            for (SkinRenderObjectBuilder builder : this.pendingBuilders.values()) {
                builder.endBatch(this.pipeline);
            }
            this.pendingBuilders.clear();
            this.pipeline.end();
        }
        if (!this.pendingBuilders2.isEmpty()) {
            this.pendingBuilders2.forEach((key, value) -> ABI.end(key, value, 0, 0, 0));
            this.pendingBuilders2.clear();
        }
    }

    public static class Pipeline {
        private final AbstractShader shader = new AbstractShader();
        private final ShaderVertexMerger merger = new ShaderVertexMerger();

        public void add(ShaderVertexObject pass) {
            this.merger.add(pass);
        }

        public void end() {
            if (this.merger.isEmpty()) {
                return;
            }
            this.merger.prepare();
            this.shader.begin();
            this.merger.forEach(group -> this.shader.apply((ShaderVertexGroup)group, () -> group.forEach(this.shader::render)));
            this.shader.end();
            this.merger.reset();
        }
    }
}

