/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HologramProjectorBlockEntityRenderer<T extends HologramProjectorBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    public HologramProjectorBlockEntityRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public void render(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        if (!((HologramProjectorBlockEntity)entity).isPowered()) {
            return;
        }
        BlockState blockState = entity.m_58900_();
        ItemStack itemStack = ((UpdatableContainerBlockEntity)entity).m_8020_(0);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinRenderTesselator context = SkinRenderTesselator.create(descriptor, Tickets.RENDERER);
        if (context == null) {
            return;
        }
        float f = 0.0625f;
        float partialTicks1 = TickUtils.ticks();
        int overLight = light;
        if (((HologramProjectorBlockEntity)entity).isOverrideLight()) {
            overLight = 0xF000F0;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        ABI.mulPose(poseStack, ((HologramProjectorBlockEntity)entity).getRenderRotations(blockState));
        poseStack.m_252880_(0.0f, 0.5f, 0.0f);
        poseStack.m_85841_(f, f, f);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        context.setLightmap(overLight);
        context.setPartialTicks(partialTicks1);
        context.setColorScheme(descriptor.getColorScheme());
        context.setReference(0.0f, itemStack);
        Rectangle3f rect = context.getBakedRenderBounds();
        this.apply(entity, rect, partialTicks1, poseStack, buffers);
        context.draw(poseStack, buffers);
        poseStack.m_85849_();
        if (ModDebugger.hologramProjector) {
            BlockPos pos = entity.m_58899_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(-pos.m_123341_()), (float)(-pos.m_123342_()), (float)(-pos.m_123343_()));
            ShapeTesselator.stroke(((RotableContainerBlockEntity)entity).getCustomRenderBoundingBox(blockState), UIColor.ORANGE, poseStack, buffers);
            poseStack.m_85849_();
        }
    }

    private void apply(T entity, Rectangle3f rect, float partialTicks, PoseStack poseStack, MultiBufferSource buffers) {
        Vector3f angle = ((HologramProjectorBlockEntity)entity).getModelAngle();
        Vector3f offset = ((HologramProjectorBlockEntity)entity).getModelOffset();
        Vector3f rotationOffset = ((HologramProjectorBlockEntity)entity).getRotationOffset();
        Vector3f rotationSpeed = ((HologramProjectorBlockEntity)entity).getRotationSpeed();
        float rotX = angle.getX();
        float speedX = rotationSpeed.getX();
        if (speedX != 0.0f) {
            rotX += partialTicks % speedX / speedX * 360.0f;
        }
        float rotY = angle.getY();
        float speedY = rotationSpeed.getY();
        if (speedY != 0.0f) {
            rotY += partialTicks % speedY / speedY * 360.0f;
        }
        float rotZ = angle.getZ();
        float speedZ = rotationSpeed.getZ();
        if (speedZ != 0.0f) {
            rotZ += partialTicks % speedZ / speedZ * 360.0f;
        }
        float scale = ((HologramProjectorBlockEntity)entity).getModelScale();
        poseStack.m_85841_(scale, scale, scale);
        if (((HologramProjectorBlockEntity)entity).isOverrideOrigin()) {
            poseStack.m_252880_(0.0f, -rect.getMaxY(), 0.0f);
        }
        poseStack.m_252880_(-offset.getX(), -offset.getY(), offset.getZ());
        if (((HologramProjectorBlockEntity)entity).shouldShowRotationPoint()) {
            ShapeTesselator.stroke(-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, UIColor.MAGENTA, poseStack, buffers);
        }
        if (ModDebugger.hologramProjector) {
            ShapeTesselator.vector(Vector3f.ZERO, 128.0f, poseStack, buffers);
        }
        ABI.mulPose(poseStack, new OpenQuaternionf(rotX, -rotY, rotZ, true));
        poseStack.m_252880_(rotationOffset.getX(), -rotationOffset.getY(), rotationOffset.getZ());
        if (ModDebugger.hologramProjector) {
            ShapeTesselator.vector(Vector3f.ZERO, 128.0f, poseStack, buffers);
        }
    }

    public int m_142163_() {
        return 272;
    }
}

