/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinnableBlockEntityRenderer<T extends SkinnableBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    public SkinnableBlockEntityRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public void render(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        SkinDescriptor descriptor = ((SkinnableBlockEntity)entity).getDescriptor();
        SkinRenderTesselator tesselator = SkinRenderTesselator.create(descriptor, Tickets.RENDERER);
        if (tesselator == null) {
            return;
        }
        float f = 0.0625f;
        BlockState blockState = entity.m_58900_();
        OpenQuaternionf rotations = ((SkinnableBlockEntity)entity).getRenderRotations(blockState);
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        ABI.mulPose(poseStack, rotations);
        poseStack.m_85841_(f, f, f);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        tesselator.setLightmap(light);
        tesselator.setPartialTicks(TickUtils.ticks());
        tesselator.setColorScheme(descriptor.getColorScheme());
        tesselator.draw(poseStack, buffers);
        poseStack.m_85849_();
        if (ModDebugger.skinnable) {
            tesselator.getBakedSkin().getBlockBounds().forEach((pos, rect) -> {
                poseStack.m_85836_();
                poseStack.m_252880_(0.5f, 0.5f, 0.5f);
                poseStack.m_85841_(f, f, f);
                ABI.mulPose(poseStack, rotations);
                poseStack.m_252880_((float)pos.m_123341_() * 16.0f, (float)pos.m_123342_() * 16.0f, (float)pos.m_123343_() * 16.0f);
                ShapeTesselator.stroke(rect, UIColor.RED, poseStack, buffers);
                poseStack.m_85849_();
            });
            BlockPos pos2 = entity.m_58899_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(-pos2.m_123341_()), (float)(-pos2.m_123342_()), (float)(-pos2.m_123343_()));
            ShapeTesselator.stroke(((RotableContainerBlockEntity)entity).getCustomRenderBoundingBox(blockState), UIColor.ORANGE, poseStack, buffers);
            poseStack.m_85849_();
        }
    }
}

