/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderObject;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderState;
import moe.plushie.armourers_workshop.core.client.other.VertexArrayBuffer;
import moe.plushie.armourers_workshop.core.client.other.VertexIndexBuffer;
import moe.plushie.armourers_workshop.core.client.shader.ShaderUniforms;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class Shader {
    private int lastMaxVertexCount = 0;
    private int lastLightmap = 0;
    private OpenMatrix4f lastLightmapMat;
    private final OpenMatrix4f noneLightmapMat = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
    private final SkinRenderState renderState = new SkinRenderState();
    private final VertexArrayBuffer arrayBuffer = new VertexArrayBuffer();
    private final VertexIndexBuffer indexBuffer = new VertexIndexBuffer(4, 6, (builder, index) -> {
        builder.accept(index);
        builder.accept(index + 1);
        builder.accept(index + 2);
        builder.accept(index + 2);
        builder.accept(index + 3);
        builder.accept(index);
    });

    public void begin() {
        RenderSystem.backupExtendedMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setExtendedMatrixFlags(1);
        RenderSystem.setExtendedTextureMatrix(OpenMatrix4f.createTranslateMatrix(0.0f, TickUtils.getPaintTextureOffset() / 256.0f, 0.0f));
        ShaderUniforms.begin();
        if (ModDebugger.wireframeRender) {
            RenderSystem.polygonMode((int)1032, (int)6913);
        }
    }

    public void end() {
        if (ModDebugger.wireframeRender) {
            RenderSystem.polygonMode((int)1032, (int)6914);
        }
        RenderSystem.setExtendedMatrixFlags(0);
        ShaderUniforms.end();
        RenderSystem.restoreExtendedMatrix();
    }

    protected void prepare(ShaderVertexGroup group) {
        this.renderState.push();
        this.lastMaxVertexCount = group.maxVertexCount;
        this.arrayBuffer.bind();
    }

    protected void clean(ShaderVertexGroup group) {
        SkinRenderObject.unbind();
        this.indexBuffer.unbind();
        this.arrayBuffer.unbind();
        this.renderState.pop();
    }

    public void apply(ShaderVertexGroup group, Runnable action) {
        this.prepare(group);
        action.run();
        this.clean(group);
    }

    public void render(ShaderVertexObject object) {
        int vertexes = this.toTriangleVertex(object.getVertexCount());
        int maxVertexes = this.toTriangleVertex(this.lastMaxVertexCount);
        OpenPoseStack poseStack = object.getPoseStack();
        RenderSystem.setExtendedLightmapTextureMatrix(this.getLightmapTextureMatrix(object));
        RenderSystem.setExtendedNormalMatrix(poseStack.lastNormal());
        RenderSystem.setExtendedModelViewMatrix(poseStack.lastPose());
        ShaderUniforms.getInstance().apply();
        object.getVertexBuffer().bind();
        this.setupVertexFormat(object.getFormat(), object.getVertexOffset());
        this.setupPolygonState(object);
        this.indexBuffer.bind(maxVertexes);
        this.draw(object.getType(), this.indexBuffer.type(), vertexes, 0);
        this.cleanPolygonState(object);
        this.cleanVertexFormat(object.getFormat());
    }

    protected abstract void draw(RenderType var1, VertexIndexBuffer.IndexType var2, int var3, int var4);

    protected void setupPolygonState(ShaderVertexObject object) {
        float polygonOffset = object.getPolygonOffset();
        if (polygonOffset != 0.0f) {
            RenderSystem.polygonOffset((float)0.0f, (float)(polygonOffset * -1.0f));
            RenderSystem.enablePolygonOffset();
        }
    }

    protected void cleanPolygonState(ShaderVertexObject object) {
        float polygonOffset = object.getPolygonOffset();
        if (polygonOffset != 0.0f) {
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
        }
    }

    private void setupVertexFormat(VertexFormat format, int offset) {
        int strict = format.m_86020_();
        ImmutableList elements = format.m_86023_();
        for (int index = 0; index < elements.size(); ++index) {
            VertexFormatElement element = (VertexFormatElement)elements.get(index);
            element.m_166965_(index, (long)offset, strict);
            offset += element.m_86050_();
        }
    }

    private void cleanVertexFormat(VertexFormat vertexFormat) {
        vertexFormat.m_86024_();
    }

    private OpenMatrix4f getLightmapTextureMatrix(ShaderVertexObject object) {
        if (object.isGrowing()) {
            return this.noneLightmapMat;
        }
        int lightmap = object.getLightmap();
        if (this.lastLightmapMat == null || lightmap != this.lastLightmap) {
            int u = lightmap & 0xFFFF;
            int v = lightmap >> 16 & 0xFFFF;
            OpenMatrix4f newValue = OpenMatrix4f.createScaleMatrix(0.0f, 0.0f, 0.0f);
            newValue.m03 = u;
            newValue.m13 = v;
            this.lastLightmap = lightmap;
            this.lastLightmapMat = newValue;
        }
        return this.lastLightmapMat;
    }

    private int toTriangleVertex(int count) {
        return count + count / 2;
    }
}

