/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.util.HashMap;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShaderVertexMerger {
    private int maxVertexCount = 0;
    private final HashMap<RenderType, ShaderVertexGroup> pending = new HashMap();

    public void add(ShaderVertexObject pass) {
        this.pending.computeIfAbsent(pass.getType(), ShaderVertexGroup::new).add(pass);
        this.maxVertexCount = Math.max(this.maxVertexCount, pass.getVertexCount());
    }

    public void forEach(Consumer<ShaderVertexGroup> consumer) {
        for (RenderType renderType : SkinRenderType.RENDER_ORDERING_FACES) {
            ShaderVertexGroup group = this.pending.get(renderType);
            if (group == null || group.isEmpty()) continue;
            group.maxVertexCount = this.maxVertexCount;
            consumer.accept(group);
        }
    }

    public void prepare() {
    }

    public void reset() {
        this.pending.forEach((? super K renderType, ? super V group) -> group.clear());
    }

    public boolean isEmpty() {
        return this.maxVertexCount == 0;
    }
}

