/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.plugin;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.core.client.layer.ForwardingLayer;
import moe.plushie.armourers_workshop.core.client.skinrender.LivingSkinRenderer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ForwardingLayerPlugin<T extends LivingEntity, M extends IModel>
implements LivingSkinRenderer.Plugin<T, M> {
    private final ArrayList<Entry> entries = new ArrayList();

    public <R extends RenderLayer<?, ?>> void register(Class<R> layerType, BiPredicate<T, M> tester) {
        Entry entry = new Entry();
        entry.layerType = layerType;
        entry.layerFactory = ForwardingLayer.when(tester);
        this.entries.add(entry);
    }

    @Override
    public RenderLayer<T, EntityModel<T>> getOverrideLayer(LivingEntityRenderer<T, EntityModel<T>> entityRenderer, RenderLayer<T, EntityModel<T>> renderLayer) {
        for (Entry entry : this.entries) {
            RenderLayer newValue;
            if (!entry.layerType.isInstance(renderLayer) || (newValue = entry.layerFactory.apply((RenderLayerParent<LivingEntityRenderer<T, EntityModel<T>>, EntityModel<LivingEntityRenderer<T, EntityModel<T>>>>)entityRenderer, (RenderLayer<LivingEntityRenderer<T, EntityModel<T>>, EntityModel<LivingEntityRenderer<T, EntityModel<T>>>>)renderLayer)) == null) continue;
            return newValue;
        }
        return null;
    }

    private class Entry {
        Class<?> layerType;
        BiFunction<RenderLayerParent<T, EntityModel<T>>, RenderLayer<T, EntityModel<T>>, RenderLayer<T, EntityModel<T>>> layerFactory;

        private Entry() {
        }
    }
}

