/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.skin.ISkinFileManager;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.SkinUUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class LocalDataService
implements ISkinFileManager {
    private static LocalDataService RUNNING;
    private final File rootPath;
    private final HashMap<String, Node> nodes = new HashMap();
    private String lastGenUUID = "";

    public LocalDataService(File rootPath) {
        this.rootPath = rootPath;
        this.loadLegacyNodes();
        this.loadNodes();
    }

    public static LocalDataService getInstance() {
        return Objects.requireNonNull(RUNNING);
    }

    public static void start(File path) {
        if (RUNNING == null) {
            RUNNING = new LocalDataService(path);
            ModLog.info("start local service of '{}'", path.getParentFile().getName());
        }
    }

    public static void stop() {
        if (RUNNING != null) {
            RUNNING = null;
            ModLog.info("stop local service", new Object[0]);
        }
    }

    public static boolean isRunning() {
        return RUNNING != null;
    }

    protected void loadLegacyNodes() {
        File indexDB = new File(this.rootPath, "index.data");
        if (!indexDB.exists()) {
            return;
        }
        File[] files = SkinFileUtils.listFiles(this.rootPath);
        if (files == null) {
            return;
        }
        ModLog.info("data fixer for db {} started", indexDB);
        for (File file : files) {
            String name = file.getName();
            if (name.equals("objects") || name.equals("index.dat")) continue;
            try {
                Node node = this.generateNode(name, file);
                if (node == null) continue;
                ModLog.info("data fixer -> upgrade {} node to new db", name);
                SkinFileUtils.deleteQuietly(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SkinFileUtils.deleteQuietly(indexDB);
        ModLog.info("data fixer for db {} completed", indexDB);
    }

    private void loadNodes() {
        File[] files = SkinFileUtils.listFiles(this.getRootFile());
        if (files != null) {
            for (File file : files) {
                this.loadNode(file);
            }
        }
    }

    private Node loadNode(File parent) {
        try {
            File indexFile = new File(parent, "0");
            CompoundTag nbt = SkinFileUtils.readNBT(indexFile);
            if (nbt != null) {
                Node node = new Node(nbt);
                this.nodes.put(node.id, node);
                return node;
            }
            Node node = this.generateNode(parent.getName(), new File(parent, "1"));
            if (node != null) {
                this.nodes.put(node.id, node);
                return node;
            }
        }
        catch (Exception e) {
            ModLog.error("can't load file: {}, pls try fix or remove it.", parent);
        }
        return null;
    }

    private Node generateNode(String identifier, File skinFile) throws Exception {
        if (!skinFile.isFile()) {
            return null;
        }
        byte[] bytes = SkinFileUtils.readFileToByteArray(skinFile);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        Skin skin = SkinFileStreamUtils.loadSkinFromStream2(stream);
        if (skin == null) {
            return null;
        }
        Node node = new Node(identifier, skin.getType(), bytes, skin.getProperties());
        node.save(new ByteArrayInputStream(bytes));
        return node;
    }

    private File getRootFile() {
        return new File(this.rootPath, "objects");
    }

    public String saveSkinFile(Skin skin) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(5120);
        SkinFileStreamUtils.saveSkinToStream(stream, skin);
        byte[] bytes = stream.toByteArray();
        Node newNode = new Node(this.getFreeUUID(), skin.getType(), bytes, skin.getProperties());
        for (Node node : this.nodes.values()) {
            if (!node.isValid() || !node.equals(newNode) || !node.equalContents(bytes)) continue;
            return node.id;
        }
        try {
            this.saveSkinFile(newNode.id, new ByteArrayInputStream(bytes), newNode);
            this.nodes.put(newNode.id, newNode);
            return newNode.id;
        }
        catch (Exception exception) {
            ModLog.error("can't save file: {}, pls try fix or remove it.", newNode.getFile().getParentFile());
            return null;
        }
    }

    @Override
    public void saveSkinFile(String identifier, InputStream inputStream, Object context) throws Exception {
        ModLog.debug("Save skin into db {}", identifier);
        if (context instanceof Node) {
            ((Node)context).save(inputStream);
            return;
        }
        byte[] bytes = SkinFileUtils.readStreamToByteArray(inputStream);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        Skin skin = SkinFileStreamUtils.loadSkinFromStream2(stream);
        if (skin == null) {
            return;
        }
        Node newNode = new Node(identifier, skin.getType(), bytes, skin.getProperties());
        newNode.save(new ByteArrayInputStream(bytes));
        this.nodes.put(newNode.id, newNode);
    }

    @Override
    public InputStream loadSkinFile(String identifier, Object context) throws Exception {
        File parent;
        ModLog.debug("Load skin from db {}", identifier);
        Node node = this.nodes.get(identifier);
        if (node == null && (parent = new File(this.getRootFile(), identifier)).isDirectory()) {
            node = this.loadNode(parent);
        }
        if (node != null && node.isValid()) {
            return new FileInputStream(node.getFile());
        }
        throw new FileNotFoundException("the node '" + identifier + "' not found!");
    }

    @Override
    public void removeSkinFile(String identifier, Object context) throws Exception {
        ModLog.debug("Remove skin from db {}", identifier);
        Node node = this.nodes.get(identifier);
        if (node != null) {
            node.remove();
            this.nodes.remove(node.id);
        }
    }

    private String getFreeUUID() {
        String uuid = this.lastGenUUID;
        while (uuid.isEmpty() || this.nodes.containsKey(uuid)) {
            uuid = SkinUUID.randomUUID().toString();
        }
        this.lastGenUUID = uuid;
        return uuid;
    }

    public class Node {
        final String id;
        final ISkinType type;
        final int version;
        final int fileSize;
        final int fileHash;
        final SkinProperties properties;
        final int propertiesHash;

        Node(String id, ISkinType type, byte[] bytes, SkinProperties properties) {
            this.id = id;
            this.type = type;
            this.version = 2;
            this.fileSize = bytes.length;
            this.fileHash = Arrays.hashCode(bytes);
            this.properties = properties;
            this.propertiesHash = properties.hashCode();
        }

        Node(CompoundTag nbt) {
            this.id = nbt.m_128461_("UUID");
            this.type = SkinTypes.byName(nbt.m_128461_("Type"));
            this.version = nbt.m_128451_("Version");
            this.fileSize = nbt.m_128451_("FileSize");
            this.fileHash = nbt.m_128451_("FileHash");
            this.properties = SkinProperties.create();
            this.properties.readFromNBT(nbt.m_128469_("Properties"));
            this.propertiesHash = nbt.m_128451_("PropertiesHash");
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("UUID", this.id);
            nbt.m_128359_("Type", this.type.getRegistryName().toString());
            nbt.m_128405_("Version", this.version);
            nbt.m_128405_("FileSize", this.fileSize);
            nbt.m_128405_("FileHash", this.fileHash);
            CompoundTag props = new CompoundTag();
            this.properties.writeToNBT(props);
            nbt.m_128365_("Properties", (Tag)props);
            nbt.m_128405_("PropertiesHash", this.propertiesHash);
            return nbt;
        }

        public void save(InputStream inputStream) throws IOException {
            SkinFileUtils.forceMkdirParent(this.getFile());
            FileOutputStream fs = new FileOutputStream(this.getFile());
            SkinFileUtils.transferTo(inputStream, fs);
            SkinFileUtils.writeNBT(this.serializeNBT(), this.getIndexFile());
        }

        public void remove() {
            SkinFileUtils.deleteQuietly(this.getFile().getParentFile());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node node = (Node)o;
            return this.fileSize == node.fileSize && this.fileHash == node.fileHash && this.propertiesHash == node.propertiesHash && this.type.equals(node.type) && this.properties.equals(node.properties);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public boolean equalContents(byte[] bytes) {
            int index;
            try (FileInputStream stream = new FileInputStream(this.getFile());){
                int readSize;
                byte[] buff = new byte[1024];
                for (index = 0; index < bytes.length; index += readSize) {
                    readSize = stream.read(buff);
                    if (readSize <= 0) {
                        break;
                    }
                    if (index + readSize > bytes.length) {
                        boolean bl = false;
                        return bl;
                    }
                    for (int i = 0; i < readSize; ++i) {
                        if (bytes[index + i] == buff[i]) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return index == bytes.length;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.fileSize, this.fileHash, this.propertiesHash);
        }

        public File getFile() {
            return new File(LocalDataService.this.rootPath, "objects/" + this.id + "/1");
        }

        public File getIndexFile() {
            return new File(LocalDataService.this.rootPath, "objects/" + this.id + "/0");
        }

        public boolean isValid() {
            return this.getFile().exists();
        }
    }
}

