/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import moe.plushie.armourers_workshop.api.common.IEntityHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.item.option.MannequinToolOptions;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModEntitySerializers;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutorIO;
import moe.plushie.armourers_workshop.init.platform.MenuManager;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.TrigUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MannequinEntity
extends ArmorStand
implements IEntityHandler {
    public static final int PLACEHOLDER_ENTITY_ID = -1;
    public static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    public static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    public static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    public static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    public static final EntityDimensions MARKER_DIMENSIONS = new EntityDimensions(0.0f, 0.0f, true);
    public static final EntityDimensions BABY_DIMENSIONS = EntityDimensions.m_20395_((float)0.5f, (float)1.0f);
    public static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.m_20395_((float)0.6f, (float)1.88f);
    public static final EntityDataAccessor<Boolean> DATA_IS_CHILD = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_FLYING = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_GHOST = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IS_VISIBLE = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> DATA_EXTRA_RENDERER = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final EntityDataAccessor<PlayerTextureDescriptor> DATA_TEXTURE = SynchedEntityData.m_135353_(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE);
    private boolean isDropEquipment = false;
    private AABB boundingBoxForCulling;

    public MannequinEntity(EntityType<? extends MannequinEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHILD, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_GHOST, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_VISIBLE, (Object)true);
        this.f_19804_.m_135372_(DATA_EXTRA_RENDERER, (Object)true);
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_TEXTURE, (Object)PlayerTextureDescriptor.EMPTY);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.readExtendedData(tag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.addExtendedData(tag);
    }

    public void readExtendedData(CompoundTag tag) {
        this.f_19804_.m_135381_(DATA_IS_CHILD, (Object)OptionalAPI.getOptionalBoolean(tag, "Small", false));
        this.f_19804_.m_135381_(DATA_IS_FLYING, (Object)OptionalAPI.getOptionalBoolean(tag, "Flying", false));
        this.f_19804_.m_135381_(DATA_IS_GHOST, (Object)OptionalAPI.getOptionalBoolean(tag, "Ghost", false));
        this.f_19804_.m_135381_(DATA_IS_VISIBLE, (Object)OptionalAPI.getOptionalBoolean(tag, "ModelVisible", true));
        this.f_19804_.m_135381_(DATA_EXTRA_RENDERER, (Object)OptionalAPI.getOptionalBoolean(tag, "ExtraRender", true));
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(OptionalAPI.getOptionalFloat(tag, "Scale", 1.0f)));
        this.f_19804_.m_135381_(DATA_TEXTURE, (Object)OptionalAPI.getOptionalTextureDescriptor(tag, "Texture", PlayerTextureDescriptor.EMPTY));
        this.readCustomPose(tag.m_128469_("Pose"));
    }

    public void addExtendedData(CompoundTag tag) {
        OptionalAPI.putOptionalBoolean(tag, "Small", (Boolean)this.f_19804_.m_135370_(DATA_IS_CHILD), false);
        OptionalAPI.putOptionalBoolean(tag, "Flying", (Boolean)this.f_19804_.m_135370_(DATA_IS_FLYING), false);
        OptionalAPI.putOptionalBoolean(tag, "Ghost", (Boolean)this.f_19804_.m_135370_(DATA_IS_GHOST), false);
        OptionalAPI.putOptionalBoolean(tag, "ModelVisible", (Boolean)this.f_19804_.m_135370_(DATA_IS_VISIBLE), true);
        OptionalAPI.putOptionalBoolean(tag, "ExtraRender", (Boolean)this.f_19804_.m_135370_(DATA_EXTRA_RENDERER), true);
        OptionalAPI.putOptionalFloat(tag, "Scale", this.m_6134_(), 1.0f);
        OptionalAPI.putOptionalTextureDescriptor(tag, "Texture", this.getTextureDescriptor(), PlayerTextureDescriptor.EMPTY);
        tag.m_128365_("Pose", (Tag)this.saveCustomPose());
    }

    public void m_7350_(EntityDataAccessor<?> dataParameter) {
        if (DATA_IS_CHILD.equals(dataParameter)) {
            this.m_6210_();
        }
        if (DATA_SCALE.equals(dataParameter)) {
            this.m_6210_();
        }
        super.m_7350_(dataParameter);
    }

    public boolean isModelVisible() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_VISIBLE);
    }

    public void setModelVisible(boolean value) {
        this.f_19804_.m_135381_(DATA_IS_VISIBLE, (Object)value);
    }

    public float m_6134_() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public boolean m_31666_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHILD);
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean isFakeFlying() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_FLYING);
    }

    public boolean m_5829_() {
        return this.m_6084_() && (Boolean)this.f_19804_.m_135370_(DATA_IS_GHOST) == false;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.m_31677_()) {
            return MARKER_DIMENSIONS;
        }
        EntityDimensions entitySize = STANDING_DIMENSIONS;
        if (this.m_6162_()) {
            entitySize = BABY_DIMENSIONS;
        }
        return entitySize.m_20388_(this.m_6134_());
    }

    public float m_6431_(Pose pose, EntityDimensions entitySize) {
        float eyeHeight = 1.62f;
        if (this.m_6162_()) {
            eyeHeight = 0.88f;
        }
        return eyeHeight * this.m_6134_();
    }

    @Override
    public ItemStack getCustomPickResult(HitResult target) {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.MANNEQUIN.get());
        if (EnvironmentExecutorIO.hasSprintDown()) {
            CompoundTag entityTag = new CompoundTag();
            this.m_7380_(entityTag);
            itemStack.m_41784_().m_128365_("EntityTag", (Tag)entityTag);
        }
        return itemStack;
    }

    public void m_5618_(float f) {
        super.m_5618_(f);
        this.m_146922_(f);
        this.f_20883_ = f;
    }

    public void m_6034_(double d, double e, double f) {
        super.m_6034_(d, e, f);
        this.boundingBoxForCulling = null;
    }

    public void changeLevel(Level level) {
        this.m_284535_(level);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.isDropEquipment = false;
        boolean flag = this.m_6084_();
        boolean flag1 = super.m_6469_(source, amount);
        if (!this.isDropEquipment && flag != this.m_6084_()) {
            this.m_31653_(source);
        }
        return flag1;
    }

    public InteractionResult m_7111_(Player player, Vec3 pos, InteractionHand hand) {
        if (this.m_31677_()) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)ModItems.MANNEQUIN_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (itemStack.m_150930_(Items.f_42656_)) {
            Component customName = null;
            if (itemStack.m_41788_() && !player.m_6144_()) {
                customName = itemStack.m_41786_();
            }
            this.m_6593_(customName);
            return InteractionResult.m_19078_((boolean)PropertyProvider.getLevel((Entity)this).m_5776_());
        }
        if (player.m_6144_()) {
            double ry = TrigUtils.getAngleDegrees(player.m_20185_(), player.m_20189_(), this.m_20185_(), this.m_20189_()) + 90.0;
            Rotations rotations = this.m_31685_();
            float yRot = this.m_146908_();
            this.m_31616_(new Rotations(rotations.m_123156_(), (float)ry - yRot, rotations.m_123158_()));
            return InteractionResult.m_19078_((boolean)PropertyProvider.getLevel((Entity)this).m_5776_());
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null && wardrobe.isEditable(player)) {
            MenuManager.openMenu(ModMenuTypes.WARDROBE, player, wardrobe);
            return InteractionResult.m_19078_((boolean)PropertyProvider.getLevel((Entity)this).m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_31646_(DamageSource source) {
        Player player = null;
        if (source.m_7639_() instanceof Player) {
            player = (Player)source.m_7639_();
        }
        if (player != null && !player.m_150110_().f_35937_) {
            Block.m_49840_((Level)PropertyProvider.getLevel((Entity)this), (BlockPos)this.m_20183_(), (ItemStack)this.createMannequinStack());
        }
        this.m_31653_(source);
    }

    protected void m_5907_() {
        super.m_5907_();
        this.isDropEquipment = true;
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null) {
            wardrobe.dropAll(arg_0 -> ((MannequinEntity)this).m_19983_(arg_0));
        }
    }

    protected ItemStack createMannequinStack() {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.MANNEQUIN.get());
        CompoundTag entityTag = itemStack.m_41698_("EntityTag");
        OptionalAPI.putOptionalFloat(entityTag, "Scale", this.m_6134_(), 1.0f);
        OptionalAPI.putOptionalTextureDescriptor(entityTag, "Texture", this.getTextureDescriptor(), PlayerTextureDescriptor.EMPTY);
        return itemStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        if (this.boundingBoxForCulling != null) {
            return this.boundingBoxForCulling;
        }
        float f = this.m_6134_();
        this.boundingBoxForCulling = this.m_20191_().m_82377_((double)(f * 3.0f), (double)(f * 2.0f), (double)(f * 2.5f));
        return this.boundingBoxForCulling;
    }

    public PlayerTextureDescriptor getTextureDescriptor() {
        return (PlayerTextureDescriptor)this.f_19804_.m_135370_(DATA_TEXTURE);
    }

    public void setTextureDescriptor(PlayerTextureDescriptor descriptor) {
        this.f_19804_.m_135381_(DATA_TEXTURE, (Object)descriptor);
    }

    public boolean isExtraRenderer() {
        return (Boolean)this.f_19804_.m_135370_(DATA_EXTRA_RENDERER);
    }

    public void setExtraRenderer(boolean value) {
        this.f_19804_.m_135381_(DATA_EXTRA_RENDERER, (Object)value);
    }

    public Container getInventory() {
        return new SimpleContainer(new ItemStack[]{this.m_21205_(), this.m_21206_()}){

            public void m_6836_(int index, ItemStack itemStack) {
                super.m_6836_(index, itemStack);
                MannequinEntity.this.m_8061_(EquipmentSlot.values()[index], itemStack);
            }
        };
    }

    public CompoundTag saveCustomPose() {
        CompoundTag tag = new CompoundTag();
        OptionalAPI.putOptionalRotations(tag, "Head", (Rotations)this.f_19804_.m_135370_(f_31546_), DEFAULT_HEAD_POSE);
        OptionalAPI.putOptionalRotations(tag, "Body", (Rotations)this.f_19804_.m_135370_(f_31547_), DEFAULT_BODY_POSE);
        OptionalAPI.putOptionalRotations(tag, "LeftArm", (Rotations)this.f_19804_.m_135370_(f_31548_), DEFAULT_LEFT_ARM_POSE);
        OptionalAPI.putOptionalRotations(tag, "RightArm", (Rotations)this.f_19804_.m_135370_(f_31549_), DEFAULT_RIGHT_ARM_POSE);
        OptionalAPI.putOptionalRotations(tag, "LeftLeg", (Rotations)this.f_19804_.m_135370_(f_31550_), DEFAULT_LEFT_LEG_POSE);
        OptionalAPI.putOptionalRotations(tag, "RightLeg", (Rotations)this.f_19804_.m_135370_(f_31527_), DEFAULT_RIGHT_LEG_POSE);
        return tag;
    }

    public void readCustomPose(CompoundTag tag) {
        this.m_31597_(OptionalAPI.getOptionalRotations(tag, "Head", DEFAULT_HEAD_POSE));
        this.m_31616_(OptionalAPI.getOptionalRotations(tag, "Body", DEFAULT_BODY_POSE));
        this.m_31623_(OptionalAPI.getOptionalRotations(tag, "LeftArm", DEFAULT_LEFT_ARM_POSE));
        this.m_31628_(OptionalAPI.getOptionalRotations(tag, "RightArm", DEFAULT_RIGHT_ARM_POSE));
        this.m_31639_(OptionalAPI.getOptionalRotations(tag, "LeftLeg", DEFAULT_LEFT_LEG_POSE));
        this.m_31651_(OptionalAPI.getOptionalRotations(tag, "RightLeg", DEFAULT_RIGHT_LEG_POSE));
    }

    public void saveMannequinToolData(CompoundTag entityTag) {
        this.addExtendedData(entityTag);
    }

    public void readMannequinToolData(CompoundTag entityTag, ItemStack itemStack) {
        Tag oldValue;
        CompoundTag newEntityTag = new CompoundTag();
        if (((Boolean)MannequinToolOptions.CHANGE_OPTION.get(itemStack)).booleanValue()) {
            newEntityTag.m_128391_(entityTag);
            newEntityTag.m_128473_("Scale");
            newEntityTag.m_128473_("Pose");
            newEntityTag.m_128473_("Texture");
        }
        if (((Boolean)MannequinToolOptions.CHANGE_SCALE.get(itemStack)).booleanValue() && (oldValue = entityTag.m_128423_("Scale")) != null) {
            newEntityTag.m_128365_("Scale", oldValue);
        }
        if (((Boolean)MannequinToolOptions.CHANGE_ROTATION.get(itemStack)).booleanValue()) {
            oldValue = entityTag.m_128469_("Pose");
            if (((Boolean)MannequinToolOptions.MIRROR_MODE.get(itemStack)).booleanValue() && !oldValue.m_128456_()) {
                CompoundTag newPoseTag = oldValue.m_6426_();
                DataSerializers.mirrorRotations((CompoundTag)oldValue, "Head", DEFAULT_HEAD_POSE, newPoseTag, "Head", DEFAULT_HEAD_POSE);
                DataSerializers.mirrorRotations((CompoundTag)oldValue, "Body", DEFAULT_BODY_POSE, newPoseTag, "Body", DEFAULT_BODY_POSE);
                DataSerializers.mirrorRotations((CompoundTag)oldValue, "RightArm", DEFAULT_RIGHT_ARM_POSE, newPoseTag, "LeftArm", DEFAULT_LEFT_ARM_POSE);
                DataSerializers.mirrorRotations((CompoundTag)oldValue, "LeftArm", DEFAULT_LEFT_ARM_POSE, newPoseTag, "RightArm", DEFAULT_RIGHT_ARM_POSE);
                DataSerializers.mirrorRotations((CompoundTag)oldValue, "RightLeg", DEFAULT_RIGHT_LEG_POSE, newPoseTag, "LeftLeg", DEFAULT_LEFT_LEG_POSE);
                DataSerializers.mirrorRotations((CompoundTag)oldValue, "LeftLeg", DEFAULT_LEFT_LEG_POSE, newPoseTag, "RightLeg", DEFAULT_RIGHT_LEG_POSE);
                oldValue = newPoseTag;
            }
            newEntityTag.m_128365_("Pose", oldValue);
        }
        if (((Boolean)MannequinToolOptions.CHANGE_TEXTURE.get(itemStack)).booleanValue() && (oldValue = entityTag.m_128423_("Texture")) != null) {
            newEntityTag.m_128365_("Texture", oldValue);
        }
        this.readExtendedData(newEntityTag);
    }
}

