/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.common.IConfigurableTool;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class UpdateConfigurableToolPacket
extends CustomPacket {
    private final InteractionHand hand;
    private final ItemStack itemStack;

    public UpdateConfigurableToolPacket(FriendlyByteBuf buffer) {
        this.hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        this.itemStack = buffer.m_130267_();
    }

    public UpdateConfigurableToolPacket(InteractionHand hand, ItemStack itemStack) {
        this.hand = hand;
        this.itemStack = itemStack;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.hand);
        buffer.m_130055_(this.itemStack);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        ItemStack oldItemStack = player.m_21120_(this.hand);
        IConfigurableTool configurableTool = ObjectUtils.safeCast(oldItemStack.m_41720_(), IConfigurableTool.class);
        if (configurableTool == null) {
            this.abort((Player)player, "update", "tried change unsupported item type.");
            return;
        }
        if (!oldItemStack.m_41720_().equals(this.itemStack.m_41720_())) {
            this.abort((Player)player, "update", "tried change item type.");
            return;
        }
        ItemStack newItemStack = oldItemStack.m_41777_();
        this.copyTo(this.itemStack, newItemStack, "Options");
        this.copyTo(this.itemStack, newItemStack, "Color");
        player.m_21008_(this.hand, newItemStack);
    }

    private void copyTo(ItemStack fromItemStack, ItemStack toItemStack, String key) {
        CompoundTag nbt = fromItemStack.m_41783_();
        Tag value = null;
        if (nbt != null) {
            value = nbt.m_128423_(key);
        }
        if (value != null) {
            CompoundTag itemTag = toItemStack.m_41784_();
            itemTag.m_128365_(key, value);
        } else {
            CompoundTag itemTag = toItemStack.m_41783_();
            if (itemTag != null) {
                itemTag.m_128473_(key);
            }
        }
    }

    private void abort(Player player, String op, String reason) {
        String playerName = player.m_6302_();
        ModLog.info("abort {} request of the '{}', reason: '{}', from: '{}', to: '{}'", op, playerName, reason, player.m_21120_(this.hand), this.itemStack);
    }
}

