/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.SkinWardrobeMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class UpdateWardrobePacket
extends CustomPacket {
    private final Mode mode;
    private final int entityId;
    private final Field field;
    private final Object fieldValue;
    private final CompoundTag compoundNBT;

    public UpdateWardrobePacket(FriendlyByteBuf buffer) {
        this.mode = (Mode)buffer.m_130066_(Mode.class);
        this.entityId = buffer.readInt();
        if (this.mode != Mode.SYNC_OPTION) {
            this.fieldValue = null;
            this.field = null;
            this.compoundNBT = buffer.m_130260_();
        } else {
            this.field = (Field)buffer.m_130066_(Field.class);
            this.fieldValue = this.field.getDataSerializer().m_6709_(buffer);
            this.compoundNBT = null;
        }
    }

    public UpdateWardrobePacket(SkinWardrobe wardrobe, Mode mode, CompoundTag compoundNBT, Field field, Object fieldValue) {
        this.mode = mode;
        this.entityId = wardrobe.getId();
        this.field = field;
        this.fieldValue = fieldValue;
        this.compoundNBT = compoundNBT;
    }

    public static UpdateWardrobePacket sync(SkinWardrobe wardrobe) {
        return new UpdateWardrobePacket(wardrobe, Mode.SYNC, wardrobe.serializeNBT(), null, null);
    }

    public static UpdateWardrobePacket pick(SkinWardrobe wardrobe, int slot, ItemStack itemStack) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("Slot", slot);
        compoundNBT.m_128365_("Item", (Tag)itemStack.m_41739_(new CompoundTag()));
        return new UpdateWardrobePacket(wardrobe, Mode.SYNC_ITEM, compoundNBT, null, null);
    }

    public static UpdateWardrobePacket field(SkinWardrobe wardrobe, Field field, Object value) {
        return new UpdateWardrobePacket(wardrobe, Mode.SYNC_OPTION, null, field, value);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.mode);
        buffer.writeInt(this.entityId);
        if (this.compoundNBT != null) {
            buffer.m_130079_(this.compoundNBT);
        }
        if (this.field != null) {
            buffer.m_130068_((Enum)this.field);
            this.field.getDataSerializer().m_6856_(buffer, this.fieldValue);
        }
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        String playerName = player.m_5446_().getString();
        if (!(player.f_36096_ instanceof SkinWardrobeMenu)) {
            ModLog.info("the wardrobe {} operation rejected for '{}'", this.getOperator(), playerName);
            return;
        }
        if (!this.checkSecurityByServer()) {
            ModLog.info("the wardrobe {} operation rejected for '{}', for security reasons.", this.getOperator(), playerName);
            return;
        }
        ModLog.debug("the wardrobe {} operation accepted for '{}'", this.getOperator(), playerName);
        SkinWardrobe wardrobe = this.apply((Player)player);
        if (wardrobe != null) {
            NetworkManager.sendToTracking(this, (Entity)player);
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        this.apply(player);
    }

    @Nullable
    private SkinWardrobe apply(Player player) {
        SkinWardrobe wardrobe = SkinWardrobe.of(PropertyProvider.getLevel((Entity)player).m_6815_(this.entityId));
        if (wardrobe == null) {
            return null;
        }
        switch (this.mode) {
            case SYNC: {
                wardrobe.deserializeNBT(this.compoundNBT);
                return wardrobe;
            }
            case SYNC_ITEM: {
                Container inventory = wardrobe.getInventory();
                int slot = this.compoundNBT.m_128451_("Slot");
                if (slot >= inventory.m_6643_()) break;
                inventory.m_6836_(slot, ItemStack.m_41712_((CompoundTag)this.compoundNBT.m_128469_("Item")));
                return wardrobe;
            }
            case SYNC_OPTION: {
                if (this.field == null) break;
                this.field.set(wardrobe, this.fieldValue);
                return wardrobe;
            }
        }
        return null;
    }

    private boolean checkSecurityByServer() {
        switch (this.mode) {
            case SYNC: {
                return false;
            }
            case SYNC_ITEM: {
                int slot = this.compoundNBT.m_128451_("Slot");
                int index = slot - SkinSlotType.DYE.getIndex();
                if (index < 8 || index >= SkinSlotType.DYE.getMaxSize()) {
                    return false;
                }
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)this.compoundNBT.m_128469_("Item"));
                if (itemStack.m_41619_()) {
                    return true;
                }
                return itemStack.m_150930_((Item)ModItems.BOTTLE.get());
            }
            case SYNC_OPTION: {
                return true;
            }
        }
        return true;
    }

    private Object getOperator() {
        if (this.field != null) {
            return this.field;
        }
        return this.mode;
    }

    public static enum Mode {
        SYNC,
        SYNC_ITEM,
        SYNC_OPTION;

    }

    public static enum Field {
        WARDROBE_ARMOUR_HEAD(EquipmentSlot.HEAD),
        WARDROBE_ARMOUR_CHEST(EquipmentSlot.CHEST),
        WARDROBE_ARMOUR_LEGS(EquipmentSlot.LEGS),
        WARDROBE_ARMOUR_FEET(EquipmentSlot.FEET),
        WARDROBE_EXTRA_RENDER(SkinWardrobe::shouldRenderExtra, SkinWardrobe::setRenderExtra),
        MANNEQUIN_IS_CHILD(MannequinEntity.DATA_IS_CHILD),
        MANNEQUIN_IS_FLYING(MannequinEntity.DATA_IS_FLYING),
        MANNEQUIN_IS_VISIBLE(MannequinEntity.DATA_IS_VISIBLE),
        MANNEQUIN_IS_GHOST(MannequinEntity.DATA_IS_GHOST),
        MANNEQUIN_EXTRA_RENDER(MannequinEntity.DATA_EXTRA_RENDERER),
        MANNEQUIN_POSE(DataSerializers.COMPOUND_TAG, MannequinEntity::saveCustomPose, MannequinEntity::readCustomPose),
        MANNEQUIN_POSITION(DataSerializers.VECTOR_3D, Entity::m_20182_, Entity::m_20219_),
        MANNEQUIN_TEXTURE(MannequinEntity.DATA_TEXTURE);

        private final boolean broadcastChanges;
        private final DataAccessor<SkinWardrobe, ?> dataAccessor;

        private Field(EquipmentSlot slotType) {
            this(w -> w.shouldRenderEquipment(slotType), (w, v) -> w.setRenderEquipment(slotType, (boolean)v));
        }

        private Field(Function<SkinWardrobe, Boolean> supplier, BiConsumer<SkinWardrobe, Boolean> applier) {
            this.broadcastChanges = true;
            this.dataAccessor = DataAccessor.withDataSerializer(SkinWardrobe.class, DataSerializers.BOOLEAN).withSupplier(supplier).withApplier(applier);
        }

        private <S extends Entity, T> Field(IEntitySerializer<T> dataSerializer, Function<S, T> supplier, BiConsumer<S, T> applier) {
            this.broadcastChanges = false;
            this.dataAccessor = DataAccessor.withDataSerializer(SkinWardrobe.class, dataSerializer).withSupplier(wardrobe -> {
                if (wardrobe.getEntity() != null) {
                    return supplier.apply((Entity)ObjectUtils.unsafeCast(wardrobe.getEntity()));
                }
                return null;
            }).withApplier((wardrobe, value) -> {
                if (wardrobe.getEntity() != null) {
                    applier.accept((Entity)ObjectUtils.unsafeCast(wardrobe.getEntity()), value);
                }
            });
        }

        private <T> Field(EntityDataAccessor<T> dataParameter) {
            this(DataSerializers.of(dataParameter.m_135016_()), e -> e.m_20088_().m_135370_(dataParameter), (e, v) -> e.m_20088_().m_135381_(dataParameter, v));
        }

        public <T> void set(SkinWardrobe wardrobe, T value) {
            DataAccessor<SkinWardrobe, T> dataAccessor = this.getDataAccessor();
            dataAccessor.set(wardrobe, value);
        }

        public <T> T get(SkinWardrobe wardrobe, T defaultValue) {
            DataAccessor<SkinWardrobe, T> dataAccessor = this.getDataAccessor();
            T value = dataAccessor.get(wardrobe);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public <T> DataAccessor<SkinWardrobe, T> getDataAccessor() {
            return (DataAccessor)ObjectUtils.unsafeCast(this.dataAccessor);
        }

        public <T> IEntitySerializer<T> getDataSerializer() {
            DataAccessor<SkinWardrobe, T> dataAccessor = this.getDataAccessor();
            return dataAccessor.dataSerializer;
        }
    }
}

