/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.api.skin.ISkinFileProvider;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.DataManager;
import moe.plushie.armourers_workshop.core.data.LocalDataService;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.network.RequestSkinPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.data.SkinServerType;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.WorkQueue;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SkinLoader {
    private static final SkinLoader LOADER = new SkinLoader();
    private final EnumMap<DataDomain, Session> taskManager = new EnumMap(DataDomain.class);
    private final WorkQueue workQueue = new WorkQueue();
    private final HashMap<String, IResultHandler<Skin>> waiting = new HashMap();
    private final HashMap<String, ISkinFileProvider> loaders = new HashMap();
    private final ConcurrentHashMap<String, Entry> entries = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, GlobalEntry> globalEntries = new ConcurrentHashMap();

    private SkinLoader() {
        this.setup(SkinServerType.CLIENT);
    }

    public static SkinLoader getInstance() {
        return LOADER;
    }

    public void setup(SkinServerType type) {
        this.taskManager.values().forEach(Session::shutdown);
        LocalDataSession local = new LocalDataSession();
        DownloadSession download = new DownloadSession();
        if (type == SkinServerType.CLIENT) {
            ProxySession proxy = new ProxySession();
            this.taskManager.put(DataDomain.LOCAL, local);
            this.taskManager.put(DataDomain.DATABASE, proxy);
            this.taskManager.put(DataDomain.DATABASE_LINK, proxy);
            this.taskManager.put(DataDomain.DEDICATED_SERVER, proxy);
            this.taskManager.put(DataDomain.GLOBAL_SERVER, proxy);
            this.taskManager.put(DataDomain.GLOBAL_SERVER_PREVIEW, download);
        } else {
            this.taskManager.put(DataDomain.LOCAL, local);
            this.taskManager.put(DataDomain.DATABASE, local);
            this.taskManager.put(DataDomain.DATABASE_LINK, local);
            this.taskManager.put(DataDomain.DEDICATED_SERVER, local);
            this.taskManager.put(DataDomain.GLOBAL_SERVER, download);
            this.taskManager.put(DataDomain.GLOBAL_SERVER_PREVIEW, download);
        }
    }

    public void register(DataDomain domain, ISkinFileProvider loader) {
        this.loaders.put(domain.namespace(), loader);
    }

    @Nullable
    public Skin getSkin(ItemStack itemStack) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return null;
        }
        return this.getSkin(descriptor.getIdentifier());
    }

    @Nullable
    public Skin getSkin(String identifier) {
        if (identifier.isEmpty()) {
            return null;
        }
        Entry entry = this.getEntry(identifier);
        if (entry != null) {
            return entry.get();
        }
        return null;
    }

    @Nullable
    public Skin loadSkin(String identifier) {
        if (identifier.isEmpty()) {
            return null;
        }
        Entry entry = this.getOrCreateEntry(identifier);
        this.resumeRequest(entry, Method.SYNC);
        return entry.get();
    }

    public void loadSkin(String identifier, @Nullable IResultHandler<Skin> handler) {
        Entry entry = this.getOrCreateEntry(identifier);
        entry.notify(handler);
        this.resumeRequest(entry, Method.ASYNC);
    }

    public SkinDescriptor loadSkinFromDB(String identifier, ColorScheme scheme, boolean needCopy) {
        Skin skin = this.loadSkin(identifier);
        if (skin != null) {
            if (needCopy) {
                identifier = this.saveSkin(identifier, skin);
            }
            return new SkinDescriptor(identifier, skin.getType(), scheme);
        }
        return SkinDescriptor.EMPTY;
    }

    public void loadSkinFromDB(String identifier, ColorScheme scheme, IResultHandler<SkinDescriptor> handler) {
        this.getOrCreateGlobalEntry(identifier).resume((descriptor, exception) -> {
            if (descriptor != null) {
                descriptor = new SkinDescriptor((SkinDescriptor)descriptor, scheme);
            }
            handler.apply((SkinDescriptor)descriptor, exception);
        });
    }

    public String saveSkin(String identifier, Skin skin) {
        if (DataDomain.isDatabase(identifier)) {
            return identifier;
        }
        String newIdentifier = LocalDataService.getInstance().saveSkinFile(skin);
        if (newIdentifier != null) {
            identifier = DataDomain.DATABASE.normalize(newIdentifier);
            this.addSkin(identifier, skin);
        }
        return identifier;
    }

    public void addSkin(String identifier, Skin skin) {
        Entry entry = this.getOrCreateEntry(identifier);
        entry.accept(skin);
    }

    public void addSkin(String identifier, Skin skin, Exception exception) {
        ModLog.debug("'{}' => receive server skin, exception: {}", identifier, exception);
        IResultHandler<Skin> resultHandler = this.waiting.remove(identifier);
        if (resultHandler != null) {
            resultHandler.apply(skin, exception);
        }
    }

    public void removeSkin(String identifier) {
        Entry entry = this.removeEntry(identifier);
        if (entry != null && !entry.isCompleted()) {
            entry.abort(new CancellationException("removed by user"));
        }
    }

    public synchronized void prepare(SkinServerType type) {
        ModLog.debug("prepare skin loader", new Object[0]);
        this.setup(type);
    }

    public synchronized void start() {
        ModLog.debug("start skin loader", new Object[0]);
        this.workQueue.resume();
    }

    public synchronized void stop() {
        ModLog.debug("stop skin loader", new Object[0]);
        this.workQueue.pause();
        this.waiting.clear();
        this.entries.clear();
        this.globalEntries.clear();
        this.setup(SkinServerType.CLIENT);
    }

    public void submit(Runnable cmd) {
        this.workQueue.submit(cmd);
    }

    private Entry getEntry(String identifier) {
        return this.entries.get(identifier);
    }

    private Entry getOrCreateEntry(String identifier) {
        return this.entries.computeIfAbsent(identifier, Entry::new);
    }

    private GlobalEntry getOrCreateGlobalEntry(String identifier) {
        return this.globalEntries.computeIfAbsent(identifier, GlobalEntry::new);
    }

    private Entry removeEntry(String identifier) {
        return this.entries.remove(identifier);
    }

    private void resumeRequest(Entry entry, Method method) {
        if (entry.isCompleted() && !entry.isReleased()) {
            return;
        }
        Session session = this.taskManager.get((Object)DataDomain.byName(entry.identifier));
        if (session == null) {
            entry.abort(new NoSuchElementException("can't found session"));
            return;
        }
        Request req = session.request(method, entry.identifier);
        req.delegate = entry;
        session.submit(req);
    }

    public static class LocalDataSession
    extends LoadingSession {
        public LocalDataSession() {
            super("AW-SKIN-LD");
        }

        @Override
        public void loadDidFinish(Request request, Skin skin, long loadTime) {
            ModLog.debug("'{}' => did load skin from local session, time: {}ms", request.identifier, loadTime);
        }

        @Override
        public InputStream from(Request request) throws Exception {
            return DataManager.getInstance().loadSkinData(request.identifier);
        }
    }

    public static class DownloadSession
    extends LoadingSession {
        private final CacheSession caching = new CacheSession();

        public DownloadSession() {
            super("AW-SKIN-DL");
        }

        @Override
        public void shutdown() {
            super.shutdown();
            this.caching.shutdown();
        }

        @Override
        public Skin load(Request request) throws Exception {
            File cachedFile = this.caching.cachingFile(request.identifier);
            if (cachedFile.exists()) {
                try {
                    return this.caching.load(request);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.load(request);
        }

        @Override
        public void loadDidFinish(Request request, Skin skin, long loadTime) {
            ModLog.debug("'{}' => did load skin from download session, time: {}ms", request.identifier, loadTime);
            this.caching.add(request.identifier, skin);
        }

        @Override
        public InputStream from(Request request) throws Exception {
            String domain = DataDomain.getNamespace(request.identifier);
            ISkinFileProvider loader = SkinLoader.LOADER.loaders.get(domain);
            if (loader != null) {
                return loader.loadSkin(DataDomain.getPath(request.identifier));
            }
            throw new RuntimeException("can't support the '" + domain + "' protocol");
        }

        @Override
        protected ExecutorService buildThreadPool(String name, int size) {
            return super.buildThreadPool(name, 2);
        }
    }

    public static class ProxySession
    extends Session {
        private final Semaphore available = new Semaphore(0, true);
        private final CacheSession caching = new CacheSession();

        public ProxySession() {
            super("AW-SKIN-PR");
        }

        @Override
        public void shutdown() {
            super.shutdown();
            this.caching.shutdown();
        }

        @Override
        public Skin load(Request request) throws Exception {
            try {
                return this.caching.load(request);
            }
            catch (Exception exception) {
                ModLog.debug("'{}' => start request server skin", request.identifier);
                RequestSkinPacket req = new RequestSkinPacket(request.identifier);
                NetworkManager.sendToServer(req);
                return this.await(request);
            }
        }

        public Skin await(Request request) throws Exception {
            LockState state = new LockState(this.available);
            SkinLoader.LOADER.waiting.put(request.identifier, (skin, exception) -> this.receive(request, state, (Skin)skin, exception));
            boolean ignored = this.available.tryAcquire(30L, TimeUnit.SECONDS);
            state.timeout();
            if (state.skin != null) {
                this.caching.add(request.identifier, state.skin);
                return state.skin;
            }
            if (state.exception == null) {
                state.exception = new TimeoutException("request server skin");
            }
            throw state.exception;
        }

        public void receive(Request request, LockState state, Skin skin, Exception exception) {
            state.skin = skin;
            state.exception = exception;
            if (state.available != null) {
                state.release();
                return;
            }
            if (skin != null) {
                this.caching.add(request.identifier, skin);
            }
        }

        static class LockState {
            Semaphore available;
            Skin skin;
            Exception exception;

            LockState(Semaphore semaphore) {
                this.available = semaphore;
            }

            synchronized void timeout() {
                this.available = null;
            }

            synchronized void release() {
                Semaphore available = this.available;
                this.available = null;
                if (available != null) {
                    available.release();
                }
            }
        }
    }

    public static class Entry {
        public final String identifier;
        public SoftReference<Skin> skin;
        public Exception exception;
        public Status status = Status.PENDING;
        public ArrayList<IResultHandler<Skin>> handlers = new ArrayList();

        public Entry(String identifier) {
            this.identifier = identifier;
        }

        public void accept(Skin skin) {
            ModLog.debug("'{}' => finish skin loading", this.identifier);
            this.skin = new SoftReference<Skin>(skin);
            this.exception = null;
            this.status = Status.FINISHED;
            this.invoke();
        }

        public void abort(Exception exception) {
            ModLog.debug("'{}' => abort skin loading, exception: {}", this.identifier, exception);
            this.skin = null;
            this.exception = exception;
            this.status = Status.ABORTED;
            if (exception instanceof TimeoutException || exception instanceof CancellationException) {
                this.status = Status.PENDING;
            }
            this.invoke();
        }

        public void invoke() {
            if (this.handlers.isEmpty()) {
                return;
            }
            ArrayList<IResultHandler<Skin>> handlers = this.handlers;
            this.handlers = new ArrayList();
            handlers.forEach((Consumer<IResultHandler<Skin>>)((Consumer<IResultHandler>)handler -> handler.apply(this.get(), this.exception)));
        }

        public void notify(@Nullable IResultHandler<Skin> handler) {
            if (this.isCompleted()) {
                if (handler != null) {
                    handler.apply(this.get(), this.exception);
                }
                return;
            }
            if (handler != null) {
                this.handlers.add(handler);
            }
        }

        public boolean isCompleted() {
            return this.status.isCompleted();
        }

        public boolean isReleased() {
            if (this.skin != null) {
                return this.skin.get() == null;
            }
            return false;
        }

        public Skin get() {
            if (this.skin != null) {
                return this.skin.get();
            }
            return null;
        }
    }

    public static enum Method {
        ASYNC,
        SOFT_SYNC,
        SYNC;

    }

    public static class GlobalEntry
    implements IResultHandler<Skin> {
        private boolean isFinished = false;
        private boolean isRequested = false;
        private SkinDescriptor descriptor = SkinDescriptor.EMPTY;
        private Exception exception;
        private final String identifier;
        private final ArrayList<IResultHandler<SkinDescriptor>> pending = new ArrayList();

        public GlobalEntry(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public void apply(Skin skin, Exception exception) {
            this.isFinished = true;
            this.exception = exception;
            if (skin == null) {
                this.sendNotify();
                return;
            }
            String newIdentifier = LOADER.saveSkin(this.identifier, skin);
            ModLog.debug("'{}' => did load global skin into database, target: '{}'", newIdentifier);
            this.descriptor = new SkinDescriptor(newIdentifier, skin.getType(), ColorScheme.EMPTY);
            this.sendNotify();
        }

        public void resume(IResultHandler<SkinDescriptor> handler) {
            if (this.isFinished) {
                handler.apply(this.descriptor, this.exception);
                return;
            }
            this.pending.add(handler);
            if (!this.isRequested) {
                this.isRequested = true;
                ModLog.debug("'{}' => load global skin into database", this.identifier);
                LOADER.loadSkin(this.identifier, this);
            }
        }

        private void sendNotify() {
            for (IResultHandler<SkinDescriptor> handler : this.pending) {
                handler.apply(this.descriptor, this.exception);
            }
            this.pending.clear();
        }
    }

    public static abstract class Session {
        protected final HashMap<String, Request> requests = new HashMap();
        protected final ExecutorService executor;
        private boolean isRunning = false;

        public Session(String name) {
            this.executor = this.buildThreadPool(name, 1);
        }

        public abstract Skin load(Request var1) throws Exception;

        public Request request(Method method, String identifier) {
            Request task = this.getRequest(identifier);
            task.elevate(method);
            return task;
        }

        public void submit(Request request) {
            if (request.method != Method.ASYNC) {
                this.run(request);
                return;
            }
            if (!this.isRunning) {
                this.isRunning = true;
                this.executor.execute(this::run);
            }
        }

        public void shutdown() {
            this.requests.clear();
            this.executor.shutdownNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run() {
            Request task;
            while ((task = this.pollRequest()) != null) {
                this.run(task);
            }
            Session session = this;
            synchronized (session) {
                this.isRunning = false;
            }
        }

        protected void run(Request request) {
            ModLog.debug("'{}' => start load skin", request.identifier);
            try {
                Skin skin = this.load(request);
                request.accept(skin);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                request.abort(exception);
            }
        }

        protected ExecutorService buildThreadPool(String name, int size) {
            return ThreadUtils.newFixedThreadPool(size, name, 1);
        }

        protected synchronized Request pollRequest() {
            if (this.requests.isEmpty()) {
                return null;
            }
            Request request = Collections.max(this.requests.values(), Comparator.comparingInt(t -> t.level));
            if (request != null) {
                return this.requests.remove(request.identifier);
            }
            return null;
        }

        protected synchronized Request getRequest(String identifier) {
            return this.requests.computeIfAbsent(identifier, Request::new);
        }
    }

    public static class Request {
        public final String identifier;
        public int level = 0;
        public Method method = Method.ASYNC;
        public Entry delegate;

        public Request(String identifier) {
            this.identifier = identifier;
        }

        public void accept(Skin skin) {
            if (this.delegate != null) {
                this.delegate.accept(skin);
                this.delegate = null;
            }
        }

        public void abort(Exception exception) {
            if (this.delegate != null) {
                this.delegate.abort(exception);
                this.delegate = null;
            }
        }

        public void elevate(Method method) {
            ++this.level;
            if (this.method.ordinal() < method.ordinal()) {
                this.method = method;
            }
        }
    }

    public static class CacheSession
    extends LoadingSession {
        public CacheSession() {
            super("AW-SKIN-CH");
        }

        public void add(String identifier, Skin skin) {
            File cachedFile = this.cachingFile(identifier);
            if (skin == null || cachedFile == null) {
                return;
            }
            if (this.isGlobalLibraryResource(identifier)) {
                ModLog.debug("'{}' => add global skin cache", identifier);
                this.executor.execute(() -> {
                    FileOutputStream outputStream = null;
                    try {
                        SkinFileUtils.forceMkdirParent(cachedFile);
                        if (cachedFile.exists()) {
                            SkinFileUtils.deleteQuietly(cachedFile);
                        }
                        outputStream = new FileOutputStream(cachedFile);
                        SkinFileStreamUtils.saveSkinToStream(outputStream, skin);
                        outputStream.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    StreamUtils.closeQuietly(outputStream);
                });
                return;
            }
            byte[] x0 = ModContext.x0();
            byte[] x1 = ModContext.x1();
            if (x0 == null || x1 == null) {
                return;
            }
            ModLog.debug("'{}' => add skin cache", identifier);
            this.executor.execute(() -> {
                FileOutputStream fileOutputStream = null;
                CipherOutputStream cipherOutputStream = null;
                try {
                    SkinFileUtils.forceMkdirParent(cachedFile);
                    if (cachedFile.exists()) {
                        SkinFileUtils.deleteQuietly(cachedFile);
                    }
                    fileOutputStream = new FileOutputStream(cachedFile);
                    if (x1.length != 0) {
                        fileOutputStream.write(x0);
                        SecretKeySpec key = new SecretKeySpec(x1, "AES");
                        Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
                        aes.init(1, key);
                        cipherOutputStream = new CipherOutputStream(fileOutputStream, aes);
                        SkinFileStreamUtils.saveSkinToStream(cipherOutputStream, skin);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                StreamUtils.closeQuietly(cipherOutputStream, fileOutputStream);
            });
        }

        public void remove(String identifier) {
            File cachedFile = this.cachingFile(identifier);
            if (cachedFile == null || !cachedFile.exists()) {
                return;
            }
            ModLog.debug("'{}' => remove skin cache", identifier);
            this.executor.execute(() -> SkinFileUtils.deleteQuietly(cachedFile));
        }

        @Override
        public void loadDidFinish(Request request, Skin skin, long loadTime) {
            ModLog.debug("'{}' => did load skin from cache session, time: {}ms", request.identifier, loadTime);
        }

        @Override
        public InputStream from(Request request) throws Exception {
            File cacheFile = this.cachingFile(request.identifier);
            if (cacheFile == null) {
                throw new FileNotFoundException(request.identifier);
            }
            if (this.isGlobalLibraryResource(request.identifier)) {
                return new FileInputStream(cacheFile);
            }
            byte[] x0 = ModContext.x0();
            byte[] x1 = ModContext.x1();
            if (x0 == null || x1 == null) {
                throw new IllegalStateException("illegal context state");
            }
            FileInputStream inputStream = new FileInputStream(cacheFile);
            byte[] target = new byte[x0.length];
            int targetSize = ((InputStream)inputStream).read(target, 0, target.length);
            if (targetSize != x0.length || !Arrays.equals(x0, target)) {
                throw new IllegalStateException("illegal cache signature");
            }
            SecretKeySpec key = new SecretKeySpec(x1, "AES");
            Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
            aes.init(2, key);
            return new CipherInputStream(inputStream, aes);
        }

        private File cachingFile(String identifier) {
            File cacheFile = null;
            UUID t0 = ModContext.t0();
            String namespace = DataDomain.getNamespace(identifier);
            if (this.isGlobalLibraryResource(identifier) && ModConfig.Common.isGlobalSkinServer()) {
                String path = DataDomain.getPath(identifier);
                String domain = "00000000-0000-0000-0000-000000000000";
                cacheFile = this.cachingFile(domain, DataDomain.GLOBAL_SERVER.namespace(), path);
                if (!cacheFile.exists()) {
                    cacheFile = this.cachingFile(domain, namespace, path);
                }
            } else if (t0 != null) {
                String path = DataDomain.getPath(identifier);
                cacheFile = this.cachingFile(t0.toString(), namespace, path);
            }
            return cacheFile;
        }

        private File cachingFile(String domain, String namespace, String identifier) {
            File rootPath = new File(EnvironmentManager.getSkinCacheDirectory(), domain);
            File localPath = new File(rootPath, namespace);
            return new File(localPath, identifier + ".dat");
        }

        private boolean isGlobalLibraryResource(String identifier) {
            return DataDomain.GLOBAL_SERVER.matches(identifier) || DataDomain.GLOBAL_SERVER_PREVIEW.matches(identifier);
        }
    }

    public static abstract class LoadingSession
    extends Session {
        public LoadingSession(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Skin load(Request request) throws Exception {
            Skin skin;
            InputStream inputStream = null;
            try {
                inputStream = this.from(request);
                long startTime = System.currentTimeMillis();
                Skin skin2 = SkinFileStreamUtils.loadSkinFromStream2(inputStream);
                long totalTime = System.currentTimeMillis() - startTime;
                this.loadDidFinish(request, skin2, totalTime);
                skin = skin2;
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(inputStream);
                throw throwable;
            }
            StreamUtils.closeQuietly(inputStream);
            return skin;
        }

        public abstract void loadDidFinish(Request var1, Skin var2, long var3);

        public abstract InputStream from(Request var1) throws Exception;
    }

    public static enum Status {
        PENDING,
        LOADING,
        FINISHED,
        CANCELLED,
        ABORTED;


        public boolean isCompleted() {
            return this == FINISHED || this == ABORTED;
        }
    }
}

