/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.cube.impl;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataInputStream;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.LegacyCubeHelper;
import moe.plushie.armourers_workshop.core.skin.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.core.Direction;

public class SkinCubesV1
extends SkinCubes {
    private final int cubeCount;
    private final BufferSlice bufferSlice;

    public SkinCubesV1(int count) {
        this.bufferSlice = new BufferSlice(count);
        this.cubeCount = count;
    }

    @Override
    public SkinCube getCube(int index) {
        return this.bufferSlice.at(index);
    }

    @Override
    public int getCubeCount() {
        return this.cubeCount;
    }

    public static void writeToStream(SkinCubes cubes, IDataOutputStream stream) throws IOException {
        int count = cubes.getCubeCount();
        stream.writeInt(cubes.getCubeCount());
        if (cubes instanceof SkinCubesV1) {
            stream.write(((SkinCubesV1)cubes).bufferSlice.getBuffers());
            return;
        }
        IPaintColor[] paintColors = new IPaintColor[6];
        for (int i = 0; i < count; ++i) {
            SkinCube cube = cubes.getCube(i);
            Vector3i pos = cube.getPos();
            stream.writeByte(cube.getType().getId());
            stream.writeByte(pos.getX());
            stream.writeByte(pos.getY());
            stream.writeByte(pos.getZ());
            for (Direction dir : Direction.values()) {
                IPaintColor paintColor;
                paintColors[dir.m_122411_()] = paintColor = cube.getPaintColor(dir);
            }
            for (int side = 0; side < 6; ++side) {
                IPaintColor paintColor = paintColors[side];
                stream.writeInt(paintColor.getRawValue());
            }
        }
    }

    public static SkinCubesV1 readFromStream(IDataInputStream stream, int version, ISkinPartType skinPart) throws IOException, InvalidCubeTypeException {
        int size = stream.readInt();
        SkinCubesV1 cubes = new SkinCubesV1(size);
        BufferSlice bufferSlice = cubes.bufferSlice;
        if (version >= 10) {
            byte[] buffers = bufferSlice.getBuffers();
            stream.readFully(buffers, 0, size * bufferSlice.lineSize);
            for (int i = 0; i < size; ++i) {
                BufferSlice slice = bufferSlice.at(i);
                if (version < 11) {
                    for (int side = 0; side < 6; ++side) {
                        slice.setPaintType(side, (byte)-1);
                    }
                }
                cubes.usedCounter.addCube(slice.getId());
            }
            return cubes;
        }
        for (int i = 0; i < size; ++i) {
            BufferSlice slice = bufferSlice.at(i);
            LegacyCubeHelper.loadLegacyCubeData(cubes, slice, stream, version, skinPart);
            for (int side = 0; side < 6; ++side) {
                slice.setPaintType(side, (byte)-1);
            }
        }
        return cubes;
    }

    public static class BufferSlice
    extends SkinCube {
        final int lineSize = 28;
        final byte[] buffers;
        final Vector3i pos = new Vector3i(0, 0, 0);
        int writerIndex = 0;
        int readerIndex = 0;

        public BufferSlice(int count) {
            this.buffers = new byte[count * 28];
        }

        public BufferSlice at(int index) {
            this.writerIndex = index * 28;
            this.readerIndex = index * 28;
            return this;
        }

        public byte getId() {
            return this.getByte(0);
        }

        public void setId(byte id) {
            this.setByte(0, id);
        }

        public byte getX() {
            return this.getByte(1);
        }

        public void setX(byte value) {
            this.setByte(1, value);
        }

        public byte getY() {
            return this.getByte(2);
        }

        public void setY(byte value) {
            this.setByte(2, value);
        }

        public byte getZ() {
            return this.getByte(3);
        }

        public void setZ(byte value) {
            this.setByte(3, value);
        }

        public void setR(int side, byte value) {
            this.setByte(4 + side * 4, value);
        }

        public byte getR(int side) {
            return this.getByte(4 + side * 4);
        }

        public void setG(int side, byte value) {
            this.setByte(5 + side * 4, value);
        }

        public byte getG(int side) {
            return this.getByte(5 + side * 4);
        }

        public void setB(int side, byte value) {
            this.setByte(6 + side * 4, value);
        }

        public byte getB(int side) {
            return this.getByte(6 + side * 4);
        }

        public void setPaintType(int side, byte value) {
            this.setByte(7 + side * 4, value);
        }

        public byte getPaintType(int side) {
            return this.getByte(7 + side * 4);
        }

        public int getRGB(int side) {
            int color = 0;
            color |= (this.getR(side) & 0xFF) << 16;
            color |= (this.getG(side) & 0xFF) << 8;
            return color |= this.getB(side) & 0xFF;
        }

        public void setRGB(int side, int rgb) {
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            this.setR(side, (byte)r);
            this.setG(side, (byte)g);
            this.setB(side, (byte)b);
        }

        public int getColor(int side) {
            byte type = this.getPaintType(side);
            int rgb = this.getRGB(side);
            return rgb & 0xFFFFFF | (type & 0xFF) << 24;
        }

        @Override
        public void setPos(Vector3i pos) {
            this.setX((byte)pos.getX());
            this.setY((byte)pos.getY());
            this.setZ((byte)pos.getZ());
        }

        @Override
        public Vector3i getPos() {
            this.pos.setX(this.getX());
            this.pos.setY(this.getY());
            this.pos.setZ(this.getZ());
            return this.pos;
        }

        @Override
        public void setType(ISkinCubeType type) {
            this.setId((byte)type.getId());
        }

        @Override
        public ISkinCubeType getType() {
            return SkinCubeTypes.byId(this.getId());
        }

        @Override
        public void setPaintColor(Direction dir, IPaintColor paintColor) {
            int side = dir.m_122411_();
            int type = paintColor.getPaintType().getId();
            int rgb = paintColor.getRGB();
            this.setPaintType(side, (byte)type);
            this.setRGB(side, rgb);
        }

        @Override
        public IPaintColor getPaintColor(Direction dir) {
            int side = dir.m_122411_();
            byte type = this.getPaintType(side);
            int rgb = this.getRGB(side);
            return PaintColor.of(rgb, SkinPaintTypes.byId(type));
        }

        public void setByte(int offset, byte value) {
            this.buffers[this.writerIndex + offset] = value;
        }

        public byte getByte(int offset) {
            return this.buffers[this.readerIndex + offset];
        }

        public byte[] getBuffers() {
            return this.buffers;
        }
    }
}

