/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.serialize;

import com.google.common.collect.ImmutableList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataInputStream;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataSerializer;
import moe.plushie.armourers_workshop.core.skin.data.serialize.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v12.SkinSerializerV12;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v13.SkinSerializerV13;
import moe.plushie.armourers_workshop.core.skin.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.exception.NewerFileVersionException;

public class SkinSerializer {
    public static final int FILE_VERSION_V1M = 13;
    private static final ImmutableList<IDataSerializer> PROVIDERS = ImmutableList.builder().add((Object)new SkinSerializerV13()).add((Object)new SkinSerializerV12()).build();

    public static void writeToStream(Skin skin, DataOutputStream stream) throws IOException {
        if (skin.requiresAdvanceFeatures()) {
            SkinSerializer.writeToStream(skin, stream, 1397442894);
        } else {
            SkinSerializer.writeToStream(skin, stream, 13);
        }
    }

    public static void writeToStream(Skin skin, DataOutputStream stream, int fileVersion) throws IOException {
        for (IDataSerializer impl : PROVIDERS) {
            if (!impl.isSupportedVersion(fileVersion)) continue;
            impl.writeToStream(skin, IDataOutputStream.of(stream), fileVersion);
            break;
        }
    }

    public static Skin readSkinFromStream(DataInputStream stream) throws IOException, NewerFileVersionException, InvalidCubeTypeException {
        int fileVersion = stream.readInt();
        for (IDataSerializer impl : PROVIDERS) {
            if (!impl.isSupportedVersion(fileVersion)) continue;
            return impl.readFromStream(IDataInputStream.of(stream), fileVersion);
        }
        throw new NewerFileVersionException();
    }

    public static SkinFileHeader readSkinInfoFromStream(DataInputStream stream) throws IOException, NewerFileVersionException {
        int fileVersion = stream.readInt();
        for (IDataSerializer impl : PROVIDERS) {
            if (!impl.isSupportedVersion(fileVersion)) continue;
            return impl.readInfoFromStream(IDataInputStream.of(stream), fileVersion);
        }
        throw new NewerFileVersionException();
    }
}

