/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.serialize.v20;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataInputStream;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataSerializer;
import moe.plushie.armourers_workshop.core.skin.data.serialize.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.ChunkSerializers;
import moe.plushie.armourers_workshop.core.skin.exception.InvalidCubeTypeException;
import org.apache.commons.lang3.tuple.Pair;

public final class SkinSerializerV20
implements IDataSerializer {
    public static final int FILE_HEADER = 1397442894;
    public static final int FILE_VERSION = 20;
    public static final int MAX_FILE_VERSION = 20;

    @Override
    public void writeToStream(Skin skin, IDataOutputStream stream, int fileVersion) throws IOException {
        stream.writeInt(1397442894);
        stream.writeInt(20);
        stream.writeInt(0);
        stream.writeInt(0);
        ChunkSerializers.writeToStream(skin, stream);
        stream.writeInt(0);
    }

    @Override
    public Skin readFromStream(IDataInputStream stream, int fileVersion) throws IOException, InvalidCubeTypeException {
        fileVersion = stream.readInt();
        stream.readInt();
        stream.readInt();
        return ChunkSerializers.readFromStream(stream);
    }

    @Override
    public SkinFileHeader readInfoFromStream(IDataInputStream stream, int fileVersion) throws IOException {
        fileVersion = stream.readInt();
        stream.readInt();
        stream.readInt();
        Pair<ISkinType, ISkinProperties> pair = ChunkSerializers.readInfoFromStream(stream);
        return SkinFileHeader.of(fileVersion, (ISkinType)pair.getKey(), (ISkinProperties)pair.getValue());
    }

    @Override
    public int getSupportedVersion() {
        return 1397442894;
    }
}

