/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkPalette;
import net.minecraft.core.Direction;

public class ChunkCubeData {
    private final SkinCubes data;
    private final ChunkPalette palette;
    private final HashMap<ISkinCubeType, Section> sections = new HashMap();

    public ChunkCubeData(ChunkPalette palette) {
        this.data = null;
        this.palette = palette;
    }

    public ChunkCubeData(ChunkPalette palette, SkinCubes data) {
        this.palette = palette;
        this.data = data;
    }

    public void add(SkinCubes cubes) {
    }

    public void readFromStream(ChunkInputStream stream) throws IOException {
        Section section;
        while ((section = this.readSectionFromStream(stream)) != null) {
            this.sections.put(section.cubeType, section);
        }
    }

    public void writeToStream(ChunkOutputStream stream) throws IOException {
        int count = this.data.getCubeCount();
        for (int i = 0; i < count; ++i) {
            this._add(i);
        }
        for (Section section : this.sections.values()) {
            this.writeSectionToStream(section, stream);
        }
        this.writeSectionToStream(null, stream);
    }

    private Section readSectionFromStream(ChunkInputStream stream) throws IOException {
        int length = stream.readInt();
        if (length == 0) {
            return null;
        }
        ISkinCubeType cubeType = SkinCubeTypes.byId(stream.readByte());
        int offset = this.data.getCubeCount();
        return new Section(cubeType);
    }

    private void writeSectionToStream(Section section, ChunkOutputStream stream) throws IOException {
        if (section == null) {
            stream.writeInt(0);
            return;
        }
        stream.writeInt(section.indexes.size());
        stream.writeByte(section.cubeType.getId());
        HashMap<IPaintColor, Integer> colors = new HashMap<IPaintColor, Integer>();
        for (int index : section.indexes) {
            SkinCube cube = this.data.getCube(index);
            IVector3i pos = cube.getPos();
            stream.writeByte(pos.getX());
            stream.writeByte(pos.getY());
            stream.writeByte(pos.getZ());
            colors.clear();
            for (Direction dir : Direction.values()) {
                IPaintColor paintColor = cube.getPaintColor(dir);
                int face = colors.getOrDefault(paintColor, 0);
                colors.put(paintColor, face |= 1 << dir.m_122411_());
            }
            for (Map.Entry entry : colors.entrySet()) {
                stream.writeByte((Integer)entry.getValue());
                this.palette.writeColor((IPaintColor)entry.getKey(), stream);
            }
        }
    }

    private void _add(int index) {
        ISkinCubeType cubeType = this.data.getCube(index).getType();
        this.sections.computeIfAbsent(cubeType, Section::new).add(index);
    }

    public static class Section {
        private final ISkinCubeType cubeType;
        private final ArrayList<Integer> indexes = new ArrayList();

        public Section(ISkinCubeType cubeType) {
            this.cubeType = cubeType;
        }

        public void add(int index) {
            this.indexes.add(index);
        }
    }
}

