/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkInputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk.ChunkPalette;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;

public class ChunkPaintData {
    private final ChunkPalette palette;

    public ChunkPaintData(ChunkPalette palette) {
        this.palette = palette;
    }

    public SkinPaintData readFromStream(ChunkInputStream stream) throws IOException {
        SkinPaintData paintData;
        byte version = stream.readByte();
        byte slim = stream.readByte();
        if (version == 1) {
            paintData = SkinPaintData.v1();
        } else if (version == 2) {
            paintData = SkinPaintData.v2();
        } else {
            return null;
        }
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            int x = i % paintData.getWidth();
            int y = i / paintData.getWidth();
            IPaintColor paintColor = this.palette.readColor(stream);
            paintData.setColor(x, y, paintColor.getRawValue());
        }
        return paintData;
    }

    public void writeToStream(SkinPaintData paintData, ChunkOutputStream stream) throws IOException {
        int width = paintData.getWidth();
        int height = paintData.getHeight();
        if (paintData.getHeight() == 32) {
            stream.writeByte(1);
        } else {
            stream.writeByte(2);
        }
        stream.writeByte(0);
        stream.writeInt(width * height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.palette.writeColor(paintData.getColor(x, y), stream);
            }
        }
    }
}

