/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.part;

import java.util.ArrayList;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.skin.ISkinPart;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.cube.impl.SkinCubesV1;
import moe.plushie.armourers_workshop.core.skin.data.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.transform.SkinTransform;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;

public class SkinPart
implements ISkinPart {
    protected String name;
    protected ISkinPartType partType;
    protected OpenVoxelShape renderShape;
    protected Rectangle3i partBounds;
    protected SkinTransform transform = SkinTransform.IDENTIFIER;
    protected SkinProperties properties = SkinProperties.EMPTY;
    private HashMap<Long, Rectangle3i> blockGrid;
    private SkinCubes cubeData;
    private final ArrayList<SkinMarker> markerBlocks;

    public SkinPart(ISkinPartType partType, ArrayList<SkinMarker> markers, SkinCubes cubes) {
        this.partType = partType;
        this.renderShape = cubes.getRenderShape();
        this.cubeData = cubes;
        this.markerBlocks = markers;
        this.setupPartBounds();
        if (markers != null) {
            cubes.getUsedCounter().addMarkers(markers.size());
        }
    }

    public SkinProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SkinProperties properties) {
        this.properties = properties;
    }

    public int getModelCount() {
        return 0;
    }

    private void setupPartBounds() {
        if (this.partType == SkinPartTypes.BLOCK || this.partType == SkinPartTypes.BLOCK_MULTI) {
            this.setupBlockBounds();
        } else {
            this.partBounds = new Rectangle3i(this.renderShape.bounds());
        }
    }

    public void setSkinPart(ISkinPartType skinPart) {
        this.partType = skinPart;
        this.setupPartBounds();
    }

    public HashMap<BlockPos, Rectangle3i> getBlockBounds() {
        if (this.blockGrid != null) {
            HashMap<BlockPos, Rectangle3i> blockBounds = new HashMap<BlockPos, Rectangle3i>();
            this.blockGrid.forEach((key, value) -> blockBounds.put(BlockPos.m_122022_((long)key), (Rectangle3i)value));
            return blockBounds;
        }
        return null;
    }

    private void setupBlockBounds() {
        this.blockGrid = new HashMap();
        this.cubeData.forEach((i, x, y, z) -> {
            int tx = MathUtils.floor((float)(x + 8) / 16.0f);
            int ty = MathUtils.floor((float)(y + 8) / 16.0f);
            int tz = MathUtils.floor((float)(z + 8) / 16.0f);
            long key = BlockPos.m_121882_((int)(-tx), (int)(-ty), (int)tz);
            Rectangle3i rec = new Rectangle3i(-(x - tx * 16) - 1, -(y - ty * 16) - 1, z - tz * 16, 1, 1, 1);
            this.blockGrid.computeIfAbsent(key, k -> rec).union(rec);
        });
    }

    public SkinCubes getCubeData() {
        return this.cubeData;
    }

    public void clearCubeData() {
        this.cubeData = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setTransform(SkinTransform transform) {
        this.transform = transform;
    }

    public SkinTransform getTransform() {
        return this.transform;
    }

    public SkinPaintData getPaintData() {
        return null;
    }

    public Object getBlobs() {
        return null;
    }

    @Override
    public ISkinPartType getType() {
        return this.partType;
    }

    public ArrayList<SkinMarker> getMarkers() {
        return this.markerBlocks;
    }

    public String toString() {
        return "SkinPart [cubeData=" + this.cubeData + ", markerBlocks=" + this.markerBlocks + ", skinPart=" + this.partType.getRegistryName() + "]";
    }

    public static class Builder {
        private final ISkinPartType partType;
        private String name;
        private SkinCubes cubes;
        private SkinPaintData paintData;
        private SkinTransform transform = SkinTransform.IDENTIFIER;
        private ArrayList<SkinMarker> markers = new ArrayList();
        private SkinProperties properties;
        private Object blobs;
        private int id = 0;
        private Integer parentId;

        public Builder(ISkinPartType partType) {
            this.partType = partType;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder parent(Integer parentId) {
            this.parentId = parentId;
            return this;
        }

        public Builder transform(SkinTransform transform) {
            if (transform != null) {
                this.transform = transform;
            }
            return this;
        }

        public Builder cubes(SkinCubes cubes) {
            this.cubes = cubes;
            return this;
        }

        public Builder paintData(SkinPaintData paintData) {
            this.paintData = paintData;
            return this;
        }

        public Builder markers(ArrayList<SkinMarker> markers) {
            if (markers != null) {
                this.markers.addAll(markers);
            }
            return this;
        }

        public Builder properties(SkinProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder blobs(Object blobs) {
            this.blobs = blobs;
            return this;
        }

        public SkinPart build() {
            SkinPart skinPart = new SkinPart(this.partType, this.markers, this.cubes);
            skinPart.setName(this.name);
            skinPart.setTransform(this.transform);
            return skinPart;
        }
    }

    public static class Empty
    extends SkinPart {
        public Empty(ISkinPartType partType, Rectangle3i bounds, OpenVoxelShape renderShape) {
            super(partType, new ArrayList<SkinMarker>(), new SkinCubesV1(0));
            this.partBounds = bounds;
            this.renderShape = renderShape;
            this.setProperties(SkinProperties.create());
        }
    }
}

