/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transform;

import java.io.IOException;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataInputStream;
import moe.plushie.armourers_workshop.core.skin.data.base.IDataOutputStream;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class SkinTransform
implements ISkinTransform {
    public static final SkinTransform IDENTIFIER = new SkinTransform();
    private Vector3f postTranslate = Vector3f.ZERO;
    private Vector3f postRotation = Vector3f.ZERO;
    private Vector3f postScale = Vector3f.ONE;
    private Vector3f preTranslate = Vector3f.ZERO;
    private Vector3f preRotation = Vector3f.ZERO;
    private Vector3f preScale = Vector3f.ONE;

    public static SkinTransform createRotationTransform(Vector3f rotation) {
        if (!rotation.equals(Vector3f.ZERO)) {
            SkinTransform transform = new SkinTransform();
            transform.postRotation = rotation;
            return transform;
        }
        return IDENTIFIER;
    }

    public static SkinTransform createTranslateTransform(Vector3f offset) {
        if (!offset.equals(Vector3f.ZERO)) {
            SkinTransform transform = new SkinTransform();
            transform.postTranslate = offset;
            return transform;
        }
        return IDENTIFIER;
    }

    @Override
    public void pre(IPoseStack poseStack) {
        if (this == IDENTIFIER) {
            return;
        }
        this.commit(poseStack, this.preTranslate, this.preRotation, this.preScale);
    }

    @Override
    public void post(IPoseStack poseStack) {
        if (this == IDENTIFIER) {
            return;
        }
        this.commit(poseStack, this.postTranslate, this.postRotation, this.postScale);
    }

    public void readFromStream(IDataInputStream stream) throws IOException {
        this.postTranslate = this.optimize(stream.readVector3f(), Vector3f.ZERO);
        this.postRotation = this.optimize(stream.readVector3f(), Vector3f.ZERO);
        this.postScale = this.optimize(stream.readVector3f(), Vector3f.ONE);
        this.preTranslate = this.optimize(stream.readVector3f(), Vector3f.ZERO);
        this.preRotation = this.optimize(stream.readVector3f(), Vector3f.ZERO);
        this.preScale = this.optimize(stream.readVector3f(), Vector3f.ONE);
    }

    public void writeToStream(IDataOutputStream stream) throws IOException {
        stream.writeVector3f(this.postTranslate);
        stream.writeVector3f(this.postRotation);
        stream.writeVector3f(this.postScale);
        stream.writeVector3f(this.preTranslate);
        stream.writeVector3f(this.preRotation);
        stream.writeVector3f(this.preScale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkinTransform that = (SkinTransform)o;
        return this.postTranslate.equals(that.postTranslate) && this.postRotation.equals(that.postRotation) && this.postScale.equals(that.postScale) && this.preTranslate.equals(that.preTranslate) && this.preRotation.equals(that.preRotation) && this.preScale.equals(that.preScale);
    }

    public int hashCode() {
        return Objects.hash(this.postTranslate, this.postRotation, this.postScale, this.preTranslate, this.preRotation, this.preScale);
    }

    private void commit(IPoseStack poseStack, Vector3f preTranslate, Vector3f preRotation, Vector3f preScale) {
        if (preTranslate != Vector3f.ZERO) {
            poseStack.translate(preTranslate.getX(), preTranslate.getY(), preTranslate.getZ());
        }
        if (preRotation != Vector3f.ZERO) {
            poseStack.rotate(new OpenQuaternionf(preRotation.getX(), preRotation.getY(), preRotation.getZ(), true));
        }
        if (preScale != Vector3f.ONE) {
            poseStack.scale(preScale.getX(), preScale.getY(), preScale.getZ());
        }
    }

    private <T> T optimize(T value, T targetValue) {
        if (value.equals(targetValue)) {
            return targetValue;
        }
        return value;
    }
}

