/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.UUID;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModContributors {
    public static Contributor dev;
    public static final HashMap<UUID, Contributor> values;

    public static Contributor of(GameProfile gameProfile) {
        if (gameProfile == null) {
            return null;
        }
        gameProfile = PlayerTextureLoader.getInstance().loadGameProfile(gameProfile);
        UUID uuid = gameProfile.getId();
        if (uuid != null) {
            return values.get(uuid);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Contributor by(Entity entity) {
        if (entity instanceof MannequinEntity) {
            MannequinEntity mannequin = (MannequinEntity)entity;
            if (mannequin.isExtraRenderer()) {
                return ModContributors.of(mannequin.getTextureDescriptor().getProfile());
            }
            return null;
        }
        if (entity instanceof LocalPlayer) {
            return ModContributors.getCurrentContributor();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Contributor getCurrentContributor() {
        if (EnvironmentManager.isDevelopmentEnvironment()) {
            return dev;
        }
        LocalPlayer playerEntity = Minecraft.m_91087_().f_91074_;
        if (playerEntity != null) {
            return ModContributors.of(playerEntity.m_36316_());
        }
        return null;
    }

    static {
        values = Builder.builder().add("eba64cb1-0d29-4434-8d5e-31004b00488c", "RiskyKen", 16375692, ContributionFlags.PROGRAMMING).add("889bebd9-9ebc-4dec-97ee-de9907cbbc85", "SAGESSE_90", 41891, ContributionFlags.PROGRAMMING).add("3e6a5f19-bb37-4f9a-94e0-7ccd67ef1d61", "Flummie2000", 6037606, ContributionFlags.SKIN_MAKER, ContributionFlags.TRANSLATOR).add("b9e99f95-09fe-497a-8a77-1ccc839ab0f4", "VermillionX", 0x2D2D2D, ContributionFlags.SKIN_MAKER).add("0d98df01-26da-496c-ba7c-744a20a7b2c2", "Servantfly", 63373, ContributionFlags.SKIN_MAKER).add("eda5e4cb-3b09-4b2c-b56c-d27d658d2e5d", "Gray_Mooo", 0xFF0000, ContributionFlags.SKIN_MAKER).add("d7d977c8-b264-49a3-ac6e-2fae419c8191", "Thundercat_", 1370323, ContributionFlags.ARTIST, ContributionFlags.MODELER).add("e10ebd90-7922-4777-9cf6-76ecc70848ec", "LordPhrozen", 4387950, ContributionFlags.ARTIST).add("3683eab5-5a23-4cdb-b1f5-38090f1ba4a8", "TheEpicJames", 0xFF9900, ContributionFlags.ARTIST).add("a0c827d3-51c2-4cec-b6d2-0096a6b82f03", "NexusTheBrony", 0xFF00FF, ContributionFlags.ARTIST).add("2b10d8f1-3273-48a8-9061-cd5e02f45be2", "skylandersking", 0x33B773, ContributionFlags.ARTIST).add("948d2c68-a2c0-4a45-a11c-d24d612af52a", "MikaPikaaa", 13445466, ContributionFlags.ARTIST).add("996505b2-3ecd-4bce-aebd-82c713148b7e", "LillyFae", 8965833, ContributionFlags.ARTIST).add("0b37421b-e74e-4852-bf57-23907d295ea1", "andrew0030", 3079438, ContributionFlags.ARTIST).add("55b1659a-810f-4687-a514-b3201b09fd69", "V972", 4450417, ContributionFlags.TRANSLATOR).add("a865907c-6b83-47b2-a088-35688169dc6a", "EzerArch", 0xFFFFFF, ContributionFlags.TRANSLATOR).add("41dfb793-40df-4f14-aecc-9c6d265f2813", "BredFace", 2676287, ContributionFlags.TRANSLATOR).add("4dbf2d3c-884a-4db2-a050-ed0dfedcc1e3", "Equine0x", 0x800000, ContributionFlags.TRANSLATOR).add("7a84e9dd-6703-4eda-8208-bc5df8b51a61", "_Hoppang_", 803739, ContributionFlags.TRANSLATOR).add("f4977a7f-2a96-4641-a351-b3044d9866a2", "IS_Jump", 11704551, ContributionFlags.TRANSLATOR).add("58c28704-b377-4080-b3cf-e53bc53eda0a", "BlackGear27", 2299671, ContributionFlags.TRANSLATOR).add("260d5854-d2f9-4674-bcda-f311426b91de", "JasonJeong", 0x2B2B2B, ContributionFlags.TRANSLATOR).add("40aada04-7e7b-4f5f-a513-a92e581c1097", "M_H_Berre", 0xFFFF40, ContributionFlags.TRANSLATOR).add("3da3958f-f22c-4064-bddb-148dcfc101ec", "SQwatermark", 0xFF0000, ContributionFlags.TRANSLATOR).add("c1a62d17-65bc-4256-9f54-af38270f9559", "DoomRater", 10361090, ContributionFlags.WIKI_EDITOR).add("f9a9c7bc-c73a-4f0e-af73-133468513bb9", "Duvain_Feynorim", 7932379, ContributionFlags.MODELER).add("448150f9-ee48-4ce9-a3de-141a57c2857b", "KokonoMiyako", 11653099, ContributionFlags.TESTER).add("c36bf010-3fc8-4def-bba2-ab80527631af", "Shmanit", 13208139, ContributionFlags.TESTER).add("293c894b-07cc-4115-ab99-2692d63abb7e", "Deep_1mpact", 16243857, ContributionFlags.TESTER).add("b027a4f4-d480-426c-84a3-a9cb029f4b72", "Vic", 13686008, ContributionFlags.OTHER).add("4fda0709-ada7-48a6-b4bf-0bbce8c40dfa", "Nanoha", 0xFFADFF, ContributionFlags.NONE).add("31873a23-125e-4752-8607-0f1c3cb22c84", "Garoam", 6298005, ContributionFlags.NONE).build();
    }

    public static class Contributor {
        public final UUID uuid;
        public final String username;
        public final EnumSet<ContributionFlags> contributions;
        public final int color;

        public Contributor(String uuid, String username, EnumSet<ContributionFlags> contributions, int color) {
            this.uuid = UUID.fromString(uuid);
            this.username = username;
            this.contributions = contributions;
            this.color = color;
        }
    }

    public static class Builder {
        HashMap<UUID, Contributor> contributors = new HashMap();

        static Builder builder() {
            return new Builder();
        }

        Builder add(String uuid, String username, int color, ContributionFlags ... flags) {
            EnumSet<ContributionFlags> set = EnumSet.copyOf(Lists.newArrayList((Object[])flags));
            Contributor contributor = new Contributor(uuid, username, set, color);
            this.contributors.put(contributor.uuid, contributor);
            if (contributor.contributions.contains((Object)ContributionFlags.PROGRAMMING)) {
                dev = contributor;
            }
            return this;
        }

        HashMap<UUID, Contributor> build() {
            return this.contributors;
        }
    }

    public static enum ContributionFlags {
        NONE,
        PROGRAMMING,
        TRANSLATOR,
        ARTIST,
        SKIN_MAKER,
        MODELER,
        WIKI_EDITOR,
        OTHER,
        TESTER;

    }
}

