/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ExecuteCommandPacket
extends CustomPacket {
    private final Class<?> object;
    private final Mode mode;
    private final String key;
    private final Object value;

    public ExecuteCommandPacket(Class<?> object, String key, Object value, Mode mode) {
        this.object = object;
        this.mode = mode;
        this.key = key;
        this.value = value;
    }

    public ExecuteCommandPacket(FriendlyByteBuf buffer) {
        this.object = this.readClass(buffer);
        this.mode = (Mode)buffer.m_130066_(Mode.class);
        this.key = buffer.m_130136_(Short.MAX_VALUE);
        this.value = this.readObject(buffer);
    }

    public static ExecuteCommandPacket set(Class<?> obj, String key, Object value) {
        return new ExecuteCommandPacket(obj, key, value, Mode.SET);
    }

    public static ExecuteCommandPacket get(Class<?> obj, String key) {
        return new ExecuteCommandPacket(obj, key, null, Mode.GET);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.object.getName());
        buffer.m_130068_((Enum)this.mode);
        buffer.m_130070_(this.key);
        this.writeObject(buffer, this.value);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        try {
            Object data = this.value;
            switch (this.mode) {
                case GET: {
                    Field field = this.object.getField(this.key);
                    data = field.get(this.object);
                    break;
                }
                case SET: {
                    Field field = this.object.getField(this.key);
                    field.set(this.object, data);
                    break;
                }
            }
            player.m_213846_((Component)Component.m_237113_((String)(this.key + " = " + data)));
            if (ModConfig.Client.class == this.object) {
                ModConfigSpec.CLIENT.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readObject(FriendlyByteBuf buffer) {
        Object object;
        if (this.mode != Mode.SET) {
            return null;
        }
        ByteBufInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new ByteBufInputStream((ByteBuf)buffer);
            objectInputStream = new ObjectInputStream((InputStream)inputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(new Closeable[]{objectInputStream, inputStream});
                throw throwable;
            }
            StreamUtils.closeQuietly(new Closeable[]{objectInputStream, inputStream});
            return exception2;
        }
        StreamUtils.closeQuietly(new Closeable[]{objectInputStream, inputStream});
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(FriendlyByteBuf buffer, Object object) {
        if (this.mode != Mode.SET) {
            return;
        }
        ByteBufOutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = new ByteBufOutputStream((ByteBuf)buffer);
            objectOutputStream = new ObjectOutputStream((OutputStream)outputStream);
            objectOutputStream.writeObject(object);
        }
        catch (Exception exception1) {
            try {
                exception1.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(new Closeable[]{objectOutputStream, outputStream});
                throw throwable;
            }
            StreamUtils.closeQuietly(new Closeable[]{objectOutputStream, outputStream});
        }
        StreamUtils.closeQuietly(new Closeable[]{objectOutputStream, outputStream});
    }

    private Class<?> readClass(FriendlyByteBuf buffer) {
        try {
            return Class.forName(buffer.m_130136_(Short.MAX_VALUE));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static enum Mode {
        SET,
        GET;

    }
}

