/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge;

import java.util.UUID;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeNetworkManager;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.PacketSplitter;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkManagerImpl
extends AbstractForgeNetworkManager
implements NetworkManager.Impl {
    private static NetworkDispatcher dispatcher;

    public static NetworkManager.Impl getInstance(String name, String version) {
        NetworkManagerImpl impl = new NetworkManagerImpl();
        impl.init(name, version);
        return impl;
    }

    public void init(String name, String version) {
        dispatcher = new NetworkDispatcher(ModConstants.key(name));
        AbstractForgeNetworkManager.register(NetworkManagerImpl.dispatcher.channelName, version, dispatcher);
    }

    @Override
    public void sendToTracking(CustomPacket message, Entity entity) {
        dispatcher.split(message, AbstractForgeNetworkManager.Direction.PLAY_TO_CLIENT, arg_0 -> ((PacketDistributor.PacketTarget)AbstractForgeNetworkManager.trackingEntityAndSelf(() -> entity)).send(arg_0));
    }

    @Override
    public void sendTo(CustomPacket message, ServerPlayer player) {
        dispatcher.split(message, AbstractForgeNetworkManager.Direction.PLAY_TO_CLIENT, arg_0 -> ((ServerGamePacketListenerImpl)player.f_8906_).m_9829_(arg_0));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(CustomPacket message) {
        dispatcher.split(message, AbstractForgeNetworkManager.Direction.PLAY_TO_SERVER, arg_0 -> ((PacketDistributor.PacketTarget)AbstractForgeNetworkManager.server()).send(arg_0));
    }

    @Override
    public void sendToAll(CustomPacket message) {
        dispatcher.split(message, AbstractForgeNetworkManager.Direction.PLAY_TO_CLIENT, arg_0 -> ((PacketDistributor.PacketTarget)AbstractForgeNetworkManager.allPlayers()).send(arg_0));
    }

    public static class NetworkDispatcher
    implements IServerPacketHandler,
    IClientPacketHandler {
        final UUID clientUUID = UUID.randomUUID();
        final ResourceLocation channelName;
        final PacketSplitter splitter;
        final int maxPartSize = 32000;

        NetworkDispatcher(ResourceLocation channelName) {
            this.channelName = channelName;
            this.splitter = new PacketSplitter();
        }

        @SubscribeEvent
        public void onServerEvent(NetworkEvent.ClientCustomPayloadEvent event) {
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            NetworkDispatcher packetHandler = this;
            this.merge(player.m_20148_(), event.getPayload(), packet -> context.enqueueWork(() -> packet.accept(packetHandler, player)));
            context.setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public void onClientEvent(NetworkEvent.ServerCustomPayloadEvent event) {
            if (event instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
                return;
            }
            NetworkDispatcher packetHandler = this;
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            this.merge(this.clientUUID, event.getPayload(), packet -> context.enqueueWork(() -> packet.accept(packetHandler, (Player)Minecraft.m_91087_().f_91074_)));
            context.setPacketHandled(true);
        }

        public void merge(UUID uuid, FriendlyByteBuf buffer, Consumer<CustomPacket> consumer) {
            this.splitter.merge(uuid, buffer, consumer);
        }

        public void split(CustomPacket message, AbstractForgeNetworkManager.Direction dir, Consumer<Packet<?>> consumer) {
            int partSize = 32000;
            if (dir == AbstractForgeNetworkManager.Direction.PLAY_TO_CLIENT) {
                partSize = Integer.MAX_VALUE;
            }
            this.splitter.split(message, buf -> dir.buildPacket((Pair<FriendlyByteBuf, Integer>)Pair.of((Object)buf, (Object)0), this.channelName).getThis(), partSize, packet -> dir.enqueueWork(() -> consumer.accept((Packet<?>)packet)));
        }
    }
}

