/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.proxy;

import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.LocalDataService;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.entity.SeatEntity;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.data.SkinServerType;
import moe.plushie.armourers_workshop.init.ModCommands;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModHolidays;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.network.UpdateContextPacket;
import moe.plushie.armourers_workshop.init.platform.CommonNativeManager;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.init.platform.ReplayManager;
import moe.plushie.armourers_workshop.init.provider.CommonNativeProvider;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommonProxy {
    public static void init() {
        CommonProxy.setup();
        CommonProxy.register(CommonNativeManager.getProvider());
    }

    private static void setup() {
        GlobalSkinLibrary library = GlobalSkinLibrary.getInstance();
        SkinLoader.getInstance().register(DataDomain.GLOBAL_SERVER, library::downloadSkin);
        SkinLoader.getInstance().register(DataDomain.GLOBAL_SERVER_PREVIEW, library::downloadPreviewSkin);
        ReplayManager.init();
    }

    private static void register(CommonNativeProvider registries) {
        registries.willRegisterCommand(ModCommands::init);
        registries.willRegisterCustomDataPack(DataPackManager::getLoader);
        registries.willRegisterEntityAttributes(registry -> {
            registry.register((EntityType<? extends LivingEntity>)((EntityType)((IEntityType)ModEntityTypes.MANNEQUIN.get()).get()), MannequinEntity.m_21183_());
            registry.register((EntityType<? extends LivingEntity>)((EntityType)((IEntityType)ModEntityTypes.SEAT.get()).get()), SeatEntity.m_21183_());
        });
        registries.willServerTick(WorldUpdater.getInstance()::tick);
        registries.willServerStart(server -> {
            ModLog.debug("hello", new Object[0]);
            LocalDataService.start(EnvironmentManager.getSkinDatabaseDirectory());
            SkinLoader.getInstance().prepare(SkinServerType.of(server));
        });
        registries.didServerStart(server -> {
            ModLog.debug("init", new Object[0]);
            ModContext.init(server);
            SkinLoader.getInstance().start();
        });
        registries.willServerStop(server -> {
            ModLog.debug("wait", new Object[0]);
            for (ServerLevel level : server.m_129785_()) {
                WorldUpdater.getInstance().drain((Level)level);
            }
            LocalDataService.stop();
            SkinLoader.getInstance().stop();
        });
        registries.didServerStop(server -> {
            ModLog.debug("bye", new Object[0]);
            ModContext.reset();
        });
        registries.willBlockPlace(BlockUtils::snapshot);
        registries.willBlockBreak(BlockUtils::snapshot);
        registries.willPlayerLogin(player -> {
            ModLog.debug("welcome back {}", player.m_6302_());
            ReplayManager.startRecording(player.m_20194_(), player);
            ModHolidays.welcome(player);
        });
        registries.willPlayerLogout(player -> {
            ModLog.debug("good bye {}", player.m_6302_());
            SkinLibraryManager.getServer().remove((Player)player);
            ReplayManager.stopRecording(player.m_20194_(), player);
        });
        registries.willPlayerDeath(player -> {
            ModLog.debug("keep careful {}", player.m_6302_());
            SkinUtils.dropAll(player);
        });
        registries.willPlayerClone((oldPlayer, newPlayer) -> {
            ModLog.debug("woa {}", newPlayer.m_6302_());
            SkinWardrobe oldWardrobe = SkinWardrobe.of((Entity)oldPlayer);
            SkinWardrobe newWardrobe = SkinWardrobe.of((Entity)newPlayer);
            if (newWardrobe != null && oldWardrobe != null) {
                newWardrobe.deserializeNBT(oldWardrobe.serializeNBT());
                newWardrobe.broadcast();
            }
        });
        registries.didEntityTacking((entity, player) -> {
            EntityProfile entityProfile = ModEntityProfiles.getProfile(entity);
            if (entityProfile != null) {
                NetworkManager.sendWardrobeTo(entity, (ServerPlayer)player);
            }
        });
        registries.didEntityJoin(entity -> {
            SkinUtils.copySkinFromOwner(entity);
            ServerPlayer player = ObjectUtils.safeCast(entity, ServerPlayer.class);
            if (player != null) {
                NetworkManager.sendTo(new UpdateContextPacket((Player)player), player);
                NetworkManager.sendWardrobeTo((Entity)player, player);
            }
        });
    }
}

