/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.panels;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.client.gui.notification.UserNotificationCenter;
import moe.plushie.armourers_workshop.library.client.gui.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.widget.ReportList;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.impl.Report;
import moe.plushie.armourers_workshop.library.data.impl.ReportFilter;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModerationLibraryPanel
extends AbstractLibraryPanel
implements ReportList.IEventListener {
    private final ReportList listReports = this.buildReportList();
    private final ArrayList<Report> skinReports = new ArrayList();
    private int pageIndex = 0;
    private boolean isRequesting = true;
    private final ReportFilter filter = ReportFilter.OPEN;

    public ModerationLibraryPanel() {
        super("inventory.armourers_workshop.skin-library-global.panel.info", GlobalSkinLibraryWindow.Page.LIBRARY_MODERATION::equals);
        this.listReports.setFrame(this.bounds().insetBy(5.0f, 5.0f, 5.0f, 5.0f));
        this.listReports.setAutoresizingMask(18);
        this.addSubview(this.listReports);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.skinReports.isEmpty()) {
            this.pageIndex = 0;
            this.loadReportList();
        }
    }

    @Override
    public void listDidSelect(ReportList reportList, int index) {
        if (index < 0 || index >= this.skinReports.size()) {
            return;
        }
        Report report = this.skinReports.get(index);
        GlobalSkinLibrary.getInstance().getSkin(report.getSkinId(), (result, exception) -> {
            if (exception != null) {
                UserNotificationCenter.showToast(exception, "Error", null);
                return;
            }
            if (result != null) {
                this.router.showSkinDetail((ServerSkin)result, GlobalSkinLibraryWindow.Page.LIBRARY_MODERATION);
            }
        });
    }

    @Override
    public void listDidScroll(ReportList reportList, CGPoint contentOffset) {
        if (this.isRequesting) {
            return;
        }
        if (contentOffset.getY() + reportList.frame().getHeight() * 1.5f >= (float)reportList.getContentHeight()) {
            this.pageIndex += this.getMaxPerPage();
            this.loadReportList();
        }
    }

    private void loadReportList() {
        int pageIndex = this.pageIndex;
        this.isRequesting = true;
        GlobalSkinLibrary.getInstance().getReportList(pageIndex, this.getMaxPerPage(), this.filter, (result, exception) -> {
            if (result != null) {
                this.onPageLoad(pageIndex, result.getReports());
            }
        });
    }

    private void onPageLoad(int pageIndex, ArrayList<Report> reports) {
        if (pageIndex == 0) {
            this.listReports.clearItems();
        }
        ArrayList<String> names = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd MM:dd:HH");
        for (Report skinReport : reports) {
            names.add(sdf.format(skinReport.getDate()));
            names.add(String.valueOf(skinReport.getUserId()));
            names.add(String.valueOf(skinReport.getSkinId()));
            names.add(I18n.m_118938_((String)skinReport.getReportType().getLangKey(), (Object[])new Object[0]));
            names.add(skinReport.getMessage());
            this.listReports.addItem(names.toArray(new String[5]));
            names.clear();
        }
        this.skinReports.addAll(reports);
        if (reports.size() >= this.getMaxPerPage()) {
            this.isRequesting = false;
        }
    }

    private ReportList buildReportList() {
        ReportList reportList = new ReportList(new CGRect(0.0f, 0.0f, 240.0f, 120.0f));
        reportList.addColumn("date", 106);
        reportList.addColumn("userId", 40);
        reportList.addColumn("skinId", 40);
        reportList.addColumn("reportType", 72);
        reportList.addColumn("message", -1);
        reportList.setListener(this);
        return reportList;
    }

    private int getMaxPerPage() {
        return 50;
    }
}

