/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.apple.library.coregraphics.CGGraphicsState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RectangleTesselator {
    private final CGGraphicsState state;
    private final PoseStack.Pose pose;
    private float uScale;
    private float vScale;
    private ResourceLocation texture;
    private VertexConsumer builder;

    public RectangleTesselator(CGGraphicsState state) {
        this.state = state;
        this.pose = state.ctm().m_85850_();
    }

    public void begin(RenderType renderType, ResourceLocation texture, float texWidth, float texHeight) {
        this.builder = this.state.buffers().m_6299_(renderType);
        this.texture = texture;
        this.uScale = 1.0f / texWidth;
        this.vScale = 1.0f / texHeight;
    }

    public void blit(float x, float y, float width, float height, float u, float v, float zLevel) {
        this.blit(x, y, width, height, u, v, width, height, zLevel);
    }

    public void blit(float x, float y, float width, float height, float u, float v, float texWidth, float texHeight, float zLevel) {
        this.builder.m_252986_(this.pose.m_252922_(), x, y + height, zLevel).m_7421_(u * this.uScale, (v + texHeight) * this.vScale).m_5752_();
        this.builder.m_252986_(this.pose.m_252922_(), x + width, y + height, zLevel).m_7421_((u + texWidth) * this.uScale, (v + texHeight) * this.vScale).m_5752_();
        this.builder.m_252986_(this.pose.m_252922_(), x + width, y, zLevel).m_7421_((u + texWidth) * this.uScale, v * this.vScale).m_5752_();
        this.builder.m_252986_(this.pose.m_252922_(), x, y, zLevel).m_7421_(u * this.uScale, v * this.vScale).m_5752_();
    }

    public void tile(float x, float y, float width, float height, float u, float v, float texWidth, float texHeight, float zLevel) {
        float x1 = x + width;
        float y1 = y + height;
        for (float y0 = y; y0 < y1; y0 += texHeight) {
            for (float x0 = x; x0 < x1; x0 += texWidth) {
                float w0 = Math.min(x1 - x0, texWidth);
                float h0 = Math.min(y1 - y0, texHeight);
                this.blit(x0, y0, w0, h0, u, v, w0, h0, zLevel);
            }
        }
    }

    public void end() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        this.state.flush();
        this.builder = null;
    }
}

