/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.FloatBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderSystem;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class RenderSystem
extends AbstractRenderSystem {
    private static final AtomicInteger extendedMatrixFlags = new AtomicInteger();
    private static final Storage<OpenMatrix3f> extendedNormalMatrix = new Storage<OpenMatrix3f>(OpenMatrix3f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<OpenMatrix4f> extendedTextureMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<OpenMatrix4f> extendedLightmapTextureMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<OpenMatrix4f> extendedModelViewMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<PaintColor> extendedTintColor = new Storage<PaintColor>(PaintColor.WHITE);
    private static final FloatBuffer BUFFER = ObjectUtils.createFloatBuffer(3);
    private static final byte[][][] FACE_MARK_TEXTURES = new byte[][][]{new byte[][]{{1, 3}, {1, 0}, {0, 0}, {0, 3}}, new byte[][]{{1, 3}, {1, 0}, {0, 0}, {0, 3}}, new byte[][]{{1, 2}, {1, 0}, {0, 0}, {0, 2}}, new byte[][]{{1, 2}, {1, 0}, {0, 0}, {0, 2}}, new byte[][]{{3, 2}, {3, 0}, {0, 0}, {0, 2}}, new byte[][]{{3, 2}, {3, 0}, {0, 0}, {0, 2}}};
    private static final byte[][][] FACE_MARK_VERTEXES = new byte[][][]{new byte[][]{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {1, 0, 1}, {0, -1, 0}}, new byte[][]{{1, 1, 1}, {1, 1, 0}, {0, 1, 0}, {0, 1, 1}, {0, 1, 0}}, new byte[][]{{0, 0, 0}, {0, 1, 0}, {1, 1, 0}, {1, 0, 0}, {0, 0, -1}}, new byte[][]{{1, 0, 1}, {1, 1, 1}, {0, 1, 1}, {0, 0, 1}, {0, 0, 1}}, new byte[][]{{0, 0, 1}, {0, 1, 1}, {0, 1, 0}, {0, 0, 0}, {-1, 0, 0}}, new byte[][]{{1, 0, 0}, {1, 1, 0}, {1, 1, 1}, {1, 0, 1}, {1, 0, 0}}};
    private static final LinkedList<CGRect> clipBounds = new LinkedList();

    public static void call(Runnable task) {
        if (RenderSystem.isOnRenderThread()) {
            task.run();
        } else {
            RenderSystem.recordRenderCall(task::run);
        }
    }

    public static int getPixelColor(float x, float y) {
        Window window = Minecraft.m_91087_().m_91268_();
        double guiScale = window.m_85449_();
        int sx = (int)((double)x * guiScale);
        int sy = (int)((double)((float)window.m_85446_() - y) * guiScale);
        BUFFER.rewind();
        GL11.glReadPixels((int)sx, (int)sy, (int)1, (int)1, (int)6407, (int)5126, (FloatBuffer)BUFFER);
        GL11.glFinish();
        int r = Math.round(BUFFER.get() * 255.0f);
        int g = Math.round(BUFFER.get() * 255.0f);
        int b = Math.round(BUFFER.get() * 255.0f);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static void addClipRect(int x, int y, int width, int height) {
        RenderSystem.addClipRect(new CGRect(x, y, width, height));
    }

    public static void addClipRect(CGRect rect) {
        if (!clipBounds.isEmpty()) {
            CGRect rect1 = clipBounds.getLast();
            rect = rect.intersection(rect1);
        }
        clipBounds.add(rect);
        RenderSystem.applyScissor(rect);
    }

    public static void removeClipRect() {
        if (clipBounds.isEmpty()) {
            return;
        }
        clipBounds.removeLast();
        if (!clipBounds.isEmpty()) {
            RenderSystem.applyScissor(clipBounds.getLast());
        } else {
            RenderSystem.disableScissor();
        }
    }

    public static void applyScissor(CGRect rect) {
        Window window = Minecraft.m_91087_().m_91268_();
        double scale = window.m_85449_();
        double sx = (double)rect.getX() * scale;
        double sy = (double)window.m_85442_() - (double)rect.getMaxY() * scale;
        double sw = (double)rect.getWidth() * scale;
        double sh = (double)rect.getHeight() * scale;
        RenderSystem.enableScissor((int)((int)sx), (int)((int)sy), (int)((int)sw), (int)((int)sh));
    }

    public static boolean inScissorRect(CGRect rect1) {
        if (!clipBounds.isEmpty()) {
            CGRect rect = clipBounds.getLast();
            return rect.intersects(rect1);
        }
        return true;
    }

    public static boolean inScissorRect(int x, int y, int width, int height) {
        if (!clipBounds.isEmpty()) {
            CGRect rect = clipBounds.getLast();
            return rect.intersects(x, y, width, height);
        }
        return true;
    }

    public static void drawCube(PoseStack poseStack, IRectangle3i rect, float r, float g, float b, float a, MultiBufferSource buffers) {
        float x = rect.getMinX();
        float y = rect.getMinY();
        float z = rect.getMinZ();
        float w = rect.getWidth();
        float h = rect.getHeight();
        float d = rect.getDepth();
        RenderSystem.drawCube(poseStack, x, y, z, w, h, d, r, g, b, a, buffers);
    }

    public static void drawCube(PoseStack poseStack, IRectangle3f rect, float r, float g, float b, float a, MultiBufferSource buffers) {
        float x = rect.getMinX();
        float y = rect.getMinY();
        float z = rect.getMinZ();
        float w = rect.getWidth();
        float h = rect.getHeight();
        float d = rect.getDepth();
        RenderSystem.drawCube(poseStack, x, y, z, w, h, d, r, g, b, a, buffers);
    }

    public static void drawCube(PoseStack poseStack, float x, float y, float z, float w, float h, float d, float r, float g, float b, float a, MultiBufferSource buffers) {
        if (w == 0.0f || h == 0.0f || d == 0.0f) {
            return;
        }
        PoseStack.Pose pose = poseStack.m_85850_();
        SkinVertexBufferBuilder builder1 = SkinVertexBufferBuilder.getBuffer(buffers);
        VertexConsumer builder = builder1.m_6299_(SkinRenderType.IMAGE_GUIDE);
        for (Direction dir : Direction.values()) {
            RenderSystem.drawFace(pose, dir, x, y, z, w, h, d, 0.0f, 0.0f, r, g, b, a, builder);
        }
    }

    public static void drawFace(PoseStack.Pose pose, Direction dir, float x, float y, float z, float w, float h, float d, float u, float v, float r, float g, float b, float a, VertexConsumer builder) {
        byte[][] vertexes = FACE_MARK_VERTEXES[dir.m_122411_()];
        byte[][] textures = FACE_MARK_TEXTURES[dir.m_122411_()];
        float[] values = new float[]{0.0f, w, h, d};
        for (int i = 0; i < 4; ++i) {
            builder.m_252986_(pose.m_252922_(), x + (float)vertexes[i][0] * w, y + (float)vertexes[i][1] * h, z + (float)vertexes[i][2] * d).m_85950_(r, g, b, a).m_7421_(u + values[textures[i][0]], v + values[textures[i][1]]).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        }
    }

    public static void setShaderColor(UIColor color) {
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
    }

    public static void setShaderColor(PaintColor color) {
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
    }

    public static void setShaderColor(float f, float g, float h) {
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
    }

    public static OpenMatrix3f getExtendedNormalMatrix() {
        return extendedNormalMatrix.get();
    }

    public static void setExtendedNormalMatrix(OpenMatrix3f value) {
        extendedNormalMatrix.set(value);
    }

    public static OpenMatrix4f getExtendedTextureMatrix() {
        return extendedTextureMatrix.get();
    }

    public static void setExtendedTextureMatrix(OpenMatrix4f value) {
        extendedTextureMatrix.set(value);
    }

    public static OpenMatrix4f getExtendedLightmapTextureMatrix() {
        return extendedLightmapTextureMatrix.get();
    }

    public static void setExtendedLightmapTextureMatrix(OpenMatrix4f value) {
        extendedLightmapTextureMatrix.set(value);
    }

    public static OpenMatrix4f getExtendedModelViewMatrix() {
        return extendedModelViewMatrix.get();
    }

    public static void setExtendedModelViewMatrix(OpenMatrix4f value) {
        extendedModelViewMatrix.set(value);
    }

    public static void setExtendedMatrixFlags(int options) {
        extendedMatrixFlags.set(options);
    }

    public static int getExtendedMatrixFlags() {
        return extendedMatrixFlags.get();
    }

    public static void setExtendedTintColor(PaintColor tintColor) {
        extendedTintColor.set(tintColor);
    }

    public static PaintColor getExtendedTintColor() {
        return extendedTintColor.get();
    }

    public static void backupExtendedMatrix() {
        extendedTextureMatrix.save();
        extendedNormalMatrix.save();
        extendedLightmapTextureMatrix.save();
        extendedModelViewMatrix.save();
        extendedTintColor.save();
    }

    public static void restoreExtendedMatrix() {
        extendedTextureMatrix.load();
        extendedNormalMatrix.load();
        extendedLightmapTextureMatrix.load();
        extendedModelViewMatrix.load();
        extendedTintColor.load();
    }

    public static class Storage<T> {
        private T value;
        private T backup;

        public Storage(T value) {
            this.value = value;
            this.backup = value;
        }

        public void save() {
            this.backup = this.value;
        }

        public void load() {
            this.value = this.backup;
        }

        public void set(T value) {
            if (!com.mojang.blaze3d.systems.RenderSystem.isOnRenderThread()) {
                com.mojang.blaze3d.systems.RenderSystem.recordRenderCall(() -> {
                    this.value = value;
                });
            } else {
                this.value = value;
            }
        }

        public T get() {
            com.mojang.blaze3d.systems.RenderSystem.assertOnRenderThread();
            return this.value;
        }
    }
}

