/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Objects;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class SkinUtils {
    public static final byte[][][] FACE_VERTEXES = new byte[][][]{new byte[][]{{1, 1, 1}, {1, 1, 0}, {0, 1, 0}, {0, 1, 1}, {0, 1, 0}}, new byte[][]{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {1, 0, 1}, {0, -1, 0}}, new byte[][]{{0, 0, 0}, {0, 1, 0}, {1, 1, 0}, {1, 0, 0}, {0, 0, -1}}, new byte[][]{{1, 0, 1}, {1, 1, 1}, {0, 1, 1}, {0, 0, 1}, {0, 0, 1}}, new byte[][]{{1, 0, 0}, {1, 1, 0}, {1, 1, 1}, {1, 0, 1}, {1, 0, 0}}, new byte[][]{{0, 0, 1}, {0, 1, 1}, {0, 1, 0}, {0, 0, 0}, {-1, 0, 0}}};

    private SkinUtils() {
    }

    public static byte[][] getRenderVertexes(Direction direction) {
        return FACE_VERTEXES[direction.m_122411_()];
    }

    public static boolean shouldKeepWardrobe(Player entity) {
        if (entity.m_5833_()) {
            return true;
        }
        int keep = ModConfig.Common.prefersWardrobeDropOnDeath;
        if (keep == 1) {
            return true;
        }
        if (keep == 2) {
            return false;
        }
        return PropertyProvider.getLevel((Entity)entity).m_46469_().m_46207_(GameRules.f_46133_);
    }

    public static void dropAll(Player player) {
        if (SkinUtils.shouldKeepWardrobe(player)) {
            return;
        }
        SkinWardrobe oldWardrobe = SkinWardrobe.of((Entity)player);
        if (oldWardrobe != null) {
            oldWardrobe.dropAll(arg_0 -> ((Player)player).m_19983_(arg_0));
        }
    }

    public static void copySkinFromOwner(Entity entity) {
        Projectile projectile = ObjectUtils.safeCast(entity, Projectile.class);
        if (projectile == null) {
            return;
        }
        Entity owner = projectile.m_19749_();
        if (entity instanceof ThrownTrident) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.TRIDENT, 0);
            return;
        }
        if (entity instanceof AbstractArrow) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.BOW, 0);
            return;
        }
    }

    public static void copySkin(Entity src, Entity dest, SkinSlotType slotType, int index) {
        ItemStack itemStack = SkinUtils.getSkin(src, slotType, index);
        if (itemStack.m_41619_()) {
            return;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(dest);
        if (wardrobe != null) {
            wardrobe.setItem(slotType, index, itemStack.m_41777_());
            wardrobe.broadcast();
        }
    }

    public static Skin copySkin(Skin skin) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SkinFileStreamUtils.saveSkinToStream(outputStream, skin);
        byte[] skinData = outputStream.toByteArray();
        Skin skinCopy = SkinFileStreamUtils.loadSkinFromStream(new ByteArrayInputStream(skinData));
        return skinCopy;
    }

    public static ItemStack getSkin(Entity entity, SkinSlotType slotType, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        if (entity instanceof LivingEntity) {
            itemStack = SkinUtils.getUsingItem((LivingEntity)entity);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (Objects.equals(slotType.getSkinType(), descriptor.getType())) {
            return itemStack;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            ItemStack itemStack1 = wardrobe.getItem(slotType, index);
            descriptor = SkinDescriptor.of(itemStack1);
            if (Objects.equals(slotType.getSkinType(), descriptor.getType())) {
                return itemStack1;
            }
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getUsingItem(LivingEntity entity) {
        ItemStack itemStack = entity.m_21211_();
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        itemStack = entity.m_21205_();
        if (itemStack.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)itemStack)) {
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    private static int getSkinIndex(String partIndexProp, Skin skin, int partIndex) {
        String[] split = partIndexProp.split(":");
        for (int i = 0; i < split.length; ++i) {
            int count = Integer.parseInt(split[i]);
            if (partIndex >= count) continue;
            return i;
        }
        return -1;
    }

    public static VoxelShape apply(VoxelShape shape, OpenMatrix4f matrix) {
        float minX = (float)shape.m_83288_(Direction.Axis.X);
        float minY = (float)shape.m_83288_(Direction.Axis.Y);
        float minZ = (float)shape.m_83288_(Direction.Axis.Z);
        float maxX = (float)shape.m_83297_(Direction.Axis.X);
        float maxY = (float)shape.m_83297_(Direction.Axis.Y);
        float maxZ = (float)shape.m_83297_(Direction.Axis.Z);
        Vector4f[] points = new Vector4f[]{new Vector4f(minX, minY, minZ, 1.0f), new Vector4f(maxX, minY, minZ, 1.0f), new Vector4f(maxX, maxY, minZ, 1.0f), new Vector4f(minX, maxY, minZ, 1.0f), new Vector4f(minX, minY, maxZ, 1.0f), new Vector4f(maxX, minY, maxZ, 1.0f), new Vector4f(maxX, maxY, maxZ, 1.0f), new Vector4f(minX, maxY, maxZ, 1.0f)};
        boolean isReset = false;
        for (Vector4f point : points) {
            point.transform(matrix);
            if (isReset) {
                minX = Math.min(minX, point.x());
                minY = Math.min(minY, point.y());
                minZ = Math.min(minZ, point.z());
                maxX = Math.max(maxX, point.x());
                maxY = Math.max(maxY, point.y());
                maxZ = Math.max(maxZ, point.z());
                continue;
            }
            minX = point.x();
            minY = point.y();
            minZ = point.z();
            maxX = point.x();
            maxY = point.y();
            maxZ = point.z();
            isReset = true;
        }
        return Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }
}

